/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorageaddons;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RSAddonsConfig {
    private Configuration config;
    public boolean wirelessCraftingGridUsesEnergy;
    public int wirelessCraftingGridOpenUsage;
    public int wirelessCraftingGridCraftUsage;
    private static final String WIRELESS_CRAFTING_GRID = "wirelessCraftingGrid";

    public RSAddonsConfig(File configFile) {
        this.config = new Configuration(configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    public Configuration getConfig() {
        return this.config;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("refinedstorageaddons")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.wirelessCraftingGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_CRAFTING_GRID, true, "Whether the Wireless Crafting Grid uses energy");
        this.wirelessCraftingGridOpenUsage = this.config.getInt("open", WIRELESS_CRAFTING_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to open");
        this.wirelessCraftingGridCraftUsage = this.config.getInt("craft", WIRELESS_CRAFTING_GRID, 1, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to craft a single item");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(WIRELESS_CRAFTING_GRID)));
        return list;
    }
}

