/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openeye.logic.Config;
import openeye.notes.GuiButtonNotes;
import openeye.notes.GuiNotes;
import openeye.notes.NoteCategory;
import openeye.notes.NoteCollector;
import openeye.notes.NoteIcons;

public class NotesButtonInjector {
    private static final int BUTTON_NOTES_ID = 666;
    private static ITextComponent notification;

    public static void onGuiInit(GuiScreen screen, List buttonList) {
        NoteCollector noteCollector = NoteCollector.INSTANCE;
        noteCollector.finishNoteCollection();
        notification = noteCollector.getScreenMsg();
        if (!noteCollector.isEmpty()) {
            NoteCategory type = noteCollector.getMaxLevel();
            NoteIcons icon = type.icon;
            boolean blinking = noteCollector.hasImportantNotes();
            GuiButtonNotes button = NotesButtonInjector.getOrCreateInfoButton(screen, buttonList);
            button.setBlinking(blinking);
            button.setIcon(icon);
        }
    }

    private static int getX(GuiScreen screen, boolean isAbsolute, int delta) {
        return (isAbsolute ? 0 : screen.field_146294_l / 2) + delta;
    }

    private static int getY(GuiScreen screen, boolean isAbsolute, int delta) {
        return (isAbsolute ? 0 : screen.field_146295_m / 4) + delta;
    }

    private static GuiButtonNotes getOrCreateInfoButton(GuiScreen screen, List<GuiButton> buttonList) {
        for (GuiButton button : buttonList) {
            if (!(button instanceof GuiButtonNotes)) continue;
            return (GuiButtonNotes)button;
        }
        GuiButtonNotes buttonNotes = new GuiButtonNotes(666, NotesButtonInjector.getX(screen, Config.isNotesButtonPosAbsolute, Config.notesButtonPosX), NotesButtonInjector.getY(screen, Config.isNotesButtonPosAbsolute, Config.notesButtonPosY));
        buttonList.add(buttonNotes);
        return buttonNotes;
    }

    public static void onScreenDraw(GuiScreen screen) {
        if (Config.mainScreenExtraLine && notification != null) {
            screen.func_73732_a(screen.field_146297_k.field_71466_p, notification.func_150254_d(), NotesButtonInjector.getX(screen, Config.isExtraLinePosAbsolute, Config.extraLinePosX), NotesButtonInjector.getY(screen, Config.isExtraLinePosAbsolute, Config.extraLinePosY), 0xFFFFFF);
        }
    }

    public static void onActionPerformed(Minecraft mc, GuiScreen screen, GuiButton button) {
        if (button.field_146127_k == 666) {
            NotesButtonInjector.onActionPerformed(mc, screen);
        }
    }

    private static void onActionPerformed(Minecraft mc, GuiScreen screen) {
        mc.func_147108_a((GuiScreen)new GuiNotes(screen, NoteCollector.INSTANCE.getNotes()));
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent evt) {
        if (evt.getGui() instanceof GuiMainMenu) {
            NotesButtonInjector.onGuiInit(evt.getGui(), evt.getButtonList());
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.DrawScreenEvent.Post evt) {
        if (evt.getGui() instanceof GuiMainMenu) {
            NotesButtonInjector.onScreenDraw(evt.getGui());
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent evt) {
        if (evt.getGui() instanceof GuiMainMenu) {
            NotesButtonInjector.onActionPerformed(evt.getGui().field_146297_k, evt.getGui(), evt.getButton());
        }
    }

    public static void registerInjector() {
        MinecraftForge.EVENT_BUS.register((Object)new NotesButtonInjector());
    }
}

