/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;
import openeye.notes.GuiButtonNotes;
import openeye.notes.GuiNotes;
import openeye.notes.NoteIcons;
import openeye.notes.entries.NoteEntry;
import org.lwjgl.opengl.GL11;

public class GuiNotesList
extends GuiScrollingList {
    private static final int ENTRY_HEIGHT = 50;
    private final List<NoteEntry> notes;
    private final GuiNotes owner;
    private final Minecraft mc;

    public GuiNotesList(GuiNotes owner, Minecraft mc, int width, int height, int top, int bottom, int screenWidth, int screenHeight, List<NoteEntry> notes) {
        super(mc, width, height, top, bottom, 0, 50, screenWidth, screenHeight);
        this.mc = mc;
        this.owner = owner;
        this.notes = notes;
    }

    protected int getSize() {
        return this.notes.size();
    }

    protected void elementClicked(int id, boolean var2) {
        this.owner.selectNote(id);
    }

    protected boolean isSelected(int id) {
        return this.owner.isNoteSelected(id);
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int slotId, int right, int top, int height, Tessellator tessellator) {
        NoteEntry entry = this.notes.get(slotId);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.left + 10;
        this.mc.field_71446_o.func_110577_a(GuiButtonNotes.TEXTURE);
        NoteIcons icon = entry.category.icon;
        this.owner.func_73729_b(left, top, icon.textureU + 2, icon.textureV + 2, 16, 16);
        this.owner.func_73731_b(this.mc.field_71466_p, entry.title().func_150254_d(), left + 20, top + 4, 0xFFFFFF);
        String description = entry.content().func_150254_d();
        int width = right - left;
        if (!Strings.isNullOrEmpty((String)description)) {
            this.mc.field_71466_p.func_78279_b(description, left, top + 20, left + width - 10, 0xCCCCCC);
        }
    }
}

