/*
 * Decompiled with CFR 0.152.
 */
package openeye.net;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import openeye.Log;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GenericSender<I, O> {
    private final List<String> bundledRoots = ImmutableList.of((Object)"isrg_root_x1.pem", (Object)"identrust_root_x3.pem");
    private String host;
    private String path;
    private int maxRetries = 2;
    private int maxRedirects = 5;
    private int timeout = 20000;
    private EncryptionState encryptionState = EncryptionState.UNKNOWN;

    private SSLSocketFactory createSocketFactoryWithRoots(List<String> roots) throws GeneralSecurityException, IOException {
        String defaultKsAlgorithm = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(defaultKsAlgorithm);
        keyStore.load(null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (String root : roots) {
            InputStream data = this.getClass().getClassLoader().getResourceAsStream(root);
            Preconditions.checkNotNull((Object)data, (String)"Failed to found resource %s", (Object)root);
            Certificate cert = certificateFactory.generateCertificate(data);
            keyStore.setCertificateEntry(root, cert);
        }
        String defaultTmAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(defaultTmAlgorithm);
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        return sslContext.getSocketFactory();
    }

    public GenericSender(String host, String path) {
        this.host = host;
        this.path = path;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public EncryptionState getEncryptionState() {
        return this.encryptionState;
    }

    public O sendAndReceive(I request) {
        int retry = 0;
        int redirect = 0;
        while (retry < this.maxRetries) {
            Log.debug("Trying to connect to %s%s, retry %s, redirect %s", this.host, this.path, retry, redirect);
            try {
                HttpURLConnection connection;
                try {
                    Pair<HttpURLConnection, EncryptionState> result = this.createConnection();
                    this.encryptionState = (EncryptionState)((Object)Ordering.natural().min(result.getRight(), (Object)this.encryptionState));
                    connection = (HttpURLConnection)result.getLeft();
                }
                catch (GeneralSecurityException t) {
                    throw new HttpTransactionException(t);
                }
                this.trySendRequest(request, connection);
                HttpStatus statusCode = this.checkStatusCode(connection);
                if (statusCode == HttpStatus.REDIRECT) {
                    if (redirect++ >= this.maxRedirects) {
                        throw new HttpTransactionException("Too many redirects", new Object[0]);
                    }
                    String redirectPath = connection.getHeaderField("Location");
                    if (redirectPath == null) {
                        throw new HttpTransactionException("Invalid redirect", new Object[0]);
                    }
                    try {
                        URL url = new URL(redirectPath);
                        this.host = url.getHost();
                        this.path = url.getPath();
                    }
                    catch (MalformedURLException e) {
                        throw new HttpTransactionException("Invalid redirect: '%s'", new Object[]{redirectPath});
                    }
                    connection.disconnect();
                    retry = 0;
                    continue;
                }
                return this.tryReceiveResponse(connection);
            }
            catch (HttpTransactionException e) {
                throw e;
            }
            catch (SocketTimeoutException e) {
                Log.warn("Connection timed out (retry %d)", retry);
            }
            catch (Throwable t) {
                Log.warn(t, "Failed to send/receive report (retry %d)", retry);
            }
            ++retry;
        }
        throw new HttpTransactionException("Too much retries", new Object[0]);
    }

    private Pair<HttpURLConnection, EncryptionState> createConnection() throws IOException, GeneralSecurityException {
        if (System.getProperty("java.specification.version").equals("1.6")) {
            URL url = new URL("http", this.host, this.path);
            return this.createHttpConnection(url);
        }
        URL url = new URL("https", this.host, this.path);
        return this.createHttpsConnection(url);
    }

    private Pair<HttpURLConnection, EncryptionState> createHttpConnection(URL url) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.configureAndConnect(url, connection);
        return Pair.of((Object)connection, (Object)((Object)EncryptionState.NOT_SUPPORTED));
    }

    private Pair<HttpURLConnection, EncryptionState> createHttpsConnection(URL url) throws IOException, ProtocolException, GeneralSecurityException {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            this.configureAndConnect(url, connection);
            return Pair.of((Object)connection, (Object)((Object)EncryptionState.OK));
        }
        catch (SSLHandshakeException e) {
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            SSLSocketFactory sslSocketFactory = this.createSocketFactoryWithRoots(this.bundledRoots);
            connection.setSSLSocketFactory(sslSocketFactory);
            this.configureAndConnect(url, connection);
            return Pair.of((Object)connection, (Object)((Object)EncryptionState.NO_ROOT_CERTIFICATE));
        }
    }

    private void configureAndConnect(URL url, HttpURLConnection connection) throws ProtocolException, IOException {
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Encoding", "gzip");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Die Fledermaus/11");
        connection.setRequestProperty("Host", url.getAuthority());
        connection.setInstanceFollowRedirects(false);
        connection.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trySendRequest(I request, URLConnection connection) throws IOException {
        OutputStream requestStream = connection.getOutputStream();
        requestStream = new GZIPOutputStream(requestStream);
        try {
            this.encodeRequest(requestStream, request);
            requestStream.flush();
        }
        finally {
            requestStream.close();
        }
    }

    protected HttpStatus checkStatusCode(HttpURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        switch (statusCode) {
            case 200: 
            case 204: {
                return HttpStatus.OK;
            }
            case 307: 
            case 308: {
                return HttpStatus.REDIRECT;
            }
            case 404: {
                throw new HttpTransactionException("Endpoint not found", new Object[0]);
            }
            case 500: {
                throw new HttpTransactionException("Internal server error", new Object[0]);
            }
        }
        throw new HttpTransactionException("HttpStatus %d != 200", new Object[]{statusCode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected O tryReceiveResponse(HttpURLConnection connection) throws IOException {
        try (InputStream stream = connection.getInputStream();){
            O o = this.decodeResponse(stream);
            return o;
        }
    }

    protected abstract void encodeRequest(OutputStream var1, I var2) throws IOException;

    protected abstract O decodeResponse(InputStream var1) throws IOException;

    private static enum HttpStatus {
        OK,
        REDIRECT;

    }

    public static enum EncryptionState {
        NOT_SUPPORTED,
        NO_ROOT_CERTIFICATE,
        OK,
        UNKNOWN;

    }

    public static class HttpTransactionException
    extends RuntimeException {
        private HttpTransactionException(String format, Object ... args) {
            super(String.format(format, args));
        }

        private HttpTransactionException(Throwable cause) {
            super(cause);
        }
    }
}

