/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import openeye.Log;
import openeye.logic.Config;
import openeye.logic.CrashId;
import openeye.logic.ModMetaCollector;
import openeye.logic.ModState;
import openeye.logic.ReportBuilders;
import openeye.logic.ReportContext;
import openeye.logic.StateHolder;
import openeye.logic.Storages;
import openeye.logic.ThrowableLogger;
import openeye.net.ReportSender;
import openeye.notes.NoteCollector;
import openeye.protocol.FileSignature;
import openeye.protocol.ITypedStruct;
import openeye.protocol.reports.ReportCrash;
import openeye.protocol.reports.ReportPing;
import openeye.responses.IExecutableResponse;
import openeye.storage.IDataSource;
import openeye.storage.IQueryableStorage;
import openeye.struct.TypedCollections;

public class SenderWorker
implements Runnable {
    private static final String API_HOST = "openeye.openmods.info";
    private static final String API_PATH = "/api/v1/data";
    private final Future<ModMetaCollector> collector;
    private final ModState state;
    private final CountDownLatch firstMessageReceived = new CountDownLatch(1);
    private final Set<String> dangerousSignatures = Sets.newHashSet();

    public SenderWorker(Future<ModMetaCollector> collector, ModState state) {
        this.collector = collector;
        this.state = state;
    }

    private static void logException(Throwable throwable, String msg, Object ... args) {
        ThrowableLogger.processThrowable(throwable, "openeye");
        Log.warn(throwable, msg, args);
    }

    private static void store(Object report, String name) {
        try {
            IDataSource<Object> list = Storages.instance().sessionArchive.createNew(name);
            list.store(report);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to store " + name, new Object[0]);
        }
    }

    private static void filterStructs(Collection<? extends ITypedStruct> structs, Set<String> blacklist) {
        Iterator<? extends ITypedStruct> it = structs.iterator();
        while (it.hasNext()) {
            ITypedStruct struct = it.next();
            String type = struct.getType();
            if (!blacklist.contains(type)) continue;
            Log.debug("Filtered type %s(%s) from list, since it's on blacklist", type, struct);
            it.remove();
        }
    }

    private TypedCollections.ReportsList executeResponses(ModMetaCollector collector, TypedCollections.ResponseList requests) {
        Preconditions.checkState((!requests.isEmpty() ? 1 : 0) != 0);
        ReportContext context = new ReportContext(collector);
        for (IExecutableResponse request : requests) {
            request.execute(context);
        }
        this.dangerousSignatures.addAll(context.dangerousSignatures());
        return context.reports();
    }

    private static <T> SortedMap<String, T> retrieveAllSources(IQueryableStorage<T> storage) {
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (IDataSource<T> source : storage.listAll()) {
            try {
                result.put((Object)source.getId(), source.retrieve());
            }
            catch (Throwable t) {
                Log.warn(t, "Failed to read entry %s, removing", source.getId());
                source.delete();
            }
        }
        return result.build();
    }

    private static <T> void removeSources(IQueryableStorage<T> storage, Set<String> ids) {
        for (String id : ids) {
            IDataSource<T> entry = storage.getById(id);
            if (entry == null) continue;
            entry.delete();
        }
    }

    private static Collection<ReportCrash> removePendingCrashDuplicates(Map<String, ReportCrash> crashes) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, ReportCrash> e : crashes.entrySet()) {
            ReportCrash prev;
            ReportCrash crash = e.getValue();
            if (crash == null || (prev = result.put(new CrashId(crash.timestamp, crash.random), crash)) == null) continue;
            Log.warn("Found duplicated crash report %s", e.getKey());
        }
        return ImmutableList.copyOf(crashes.values());
    }

    private static SortedMap<String, ReportCrash> selectCrashes(Map<String, ReportCrash> pendingCrashes) {
        if (!Config.sendCrashes) {
            return ImmutableSortedMap.of();
        }
        if (Config.sentCrashReportsLimitTotal >= 0 && Config.sentCrashReportsLimitTotal < pendingCrashes.size()) {
            ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
            int count = Config.sentCrashReportsLimitTotal;
            for (Map.Entry<String, ReportCrash> e : pendingCrashes.entrySet()) {
                if (--count < 0) break;
                result.put(e);
            }
            return result.build();
        }
        return ImmutableSortedMap.copyOf(pendingCrashes);
    }

    protected TypedCollections.ReportsList createInitialReport(ModMetaCollector collector, Collection<ReportCrash> crashes) {
        TypedCollections.ReportsList result = new TypedCollections.ReportsList();
        try {
            if (Config.sendModList) {
                this.createAnalyticsReport(collector, result);
            }
            if (Config.pingOnInitialReport) {
                result.add(new ReportPing());
            }
            result.addAll(crashes);
        }
        catch (Exception e) {
            SenderWorker.logException(e, "Failed to create initial report", new Object[0]);
        }
        return result;
    }

    protected void createAnalyticsReport(ModMetaCollector collector, TypedCollections.ReportsList result) {
        try {
            if (Config.scanOnly) {
                result.add(ReportBuilders.buildKnownFilesReport(collector));
            } else {
                result.add(ReportBuilders.buildAnalyticsReport(collector, this.state.installedMods));
            }
        }
        catch (Exception e) {
            SenderWorker.logException(e, "Failed to create analytics report", new Object[0]);
        }
    }

    private void sendReports(ModMetaCollector collector) {
        SortedMap<String, ReportCrash> pendingCrashes = SenderWorker.retrieveAllSources(Storages.instance().pendingCrashes);
        SortedMap<String, ReportCrash> selectedPendingCrashes = SenderWorker.selectCrashes(pendingCrashes);
        Collection<ReportCrash> pendingUniqueCrashes = SenderWorker.removePendingCrashDuplicates(selectedPendingCrashes);
        TypedCollections.ReportsList currentReports = this.createInitialReport(collector, pendingUniqueCrashes);
        try {
            ReportSender sender = new ReportSender(API_HOST, API_PATH);
            while (!currentReports.isEmpty()) {
                TypedCollections.ResponseList response;
                SenderWorker.filterStructs(currentReports, Config.reportsBlacklist);
                SenderWorker.store(currentReports, "request");
                TypedCollections.ResponseList responseList = response = Config.dontSend ? null : (TypedCollections.ResponseList)sender.sendAndReceive(currentReports);
                if (response == null || response.isEmpty()) break;
                SenderWorker.filterStructs(response, Config.responseBlacklist);
                SenderWorker.store(response, "response");
                currentReports.clear();
                try {
                    currentReports = this.executeResponses(collector, response);
                }
                catch (Exception e) {
                    SenderWorker.logException(e, "Failed to execute responses", new Object[0]);
                    break;
                }
                this.firstMessageReceived.countDown();
            }
            SenderWorker.removeSources(Storages.instance().pendingCrashes, selectedPendingCrashes.keySet());
            NoteCollector.INSTANCE.addNote(sender.getEncryptionState());
        }
        catch (Exception e) {
            Log.warn(e, "Failed to send report to openeye.openmods.info/api/v1/data", new Object[0]);
        }
    }

    @Override
    public void run() {
        try {
            ModMetaCollector collector = this.collector.get();
            this.sendReports(collector);
            StateHolder.state().installedMods = collector.getAllSignatures();
            StateHolder.save();
        }
        catch (Throwable t) {
            SenderWorker.logException(t, "Failed to send data to server OpenEye", new Object[0]);
        }
        finally {
            this.firstMessageReceived.countDown();
        }
    }

    public void start() {
        Thread senderThread = new Thread(this);
        senderThread.setName("OpenEye sender thread");
        senderThread.setUncaughtExceptionHandler((t, e) -> {
            SenderWorker.logException(e, "Uncaught exception in data collector thread, report will not be send", new Object[0]);
            this.firstMessageReceived.countDown();
        });
        senderThread.start();
    }

    public void waitForFirstMsg() {
        try {
            if (!this.firstMessageReceived.await(30L, TimeUnit.SECONDS)) {
                Log.warn("OpenEye timeouted while waiting for worker thread, data will be incomplete", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            Log.warn("Thread interrupted while waiting for msg", new Object[0]);
        }
    }

    public Collection<FileSignature> listDangerousFiles() {
        ArrayList result = Lists.newArrayList();
        try {
            ModMetaCollector collector = this.collector.get();
            for (String signature : this.dangerousSignatures) {
                FileSignature file = collector.getFileForSignature(signature);
                if (signature == null) continue;
                result.add(file);
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to list dangerous files", new Object[0]);
        }
        return result;
    }
}

