/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveHandler;
import openeye.Log;
import openeye.logic.Sanitizer;

public class Sanitizers {
    public static final int PRIORITY_SAVE_DIR = 1300;
    public static final int PRIORITY_MINECRAFT_DIR = 1200;
    public static final int PRIORITY_WORK_DIR = 1100;
    public static final int PRIORITY_HOME = 1000;
    public static final int PRIORITY_SAVE_DIR_NAME = 900;
    public static final int PRIORITY_WORLD_NAME = 800;
    public static final int PRIORITY_LOCAL_IP = 700;
    public static final int PRIORITY_IP_PORT = 600;
    public static final int PRIORITY_LOCAL_HOST = 500;
    public static final int PRIORITY_LOCAL_PLAYER = 400;
    public static final int PRIORITY_PLAYER_NAME = 300;
    public static final int PRIORITY_PLAYER_ID = 200;
    public static final int PRIORITY_SYSTEM_USER = 100;
    private static final Set<String> ALREADY_REPLACED = Sets.newHashSet();
    private static final Set<String> DONT_REPLACE = Sets.newHashSet();
    private static final Map<Class<? extends Throwable>, Sanitizer> THROWABLE_SANITIZERS;
    public static final Sanitizer mainSanitizer;

    public static void addThrowableSanitizer(Class<? extends Throwable> cls, Sanitizer sanitizer) {
        THROWABLE_SANITIZERS.put(cls, sanitizer);
    }

    public static Sanitizer getSanitizerForThrowable(Class<? extends Throwable> cls) {
        Sanitizer result = THROWABLE_SANITIZERS.get(cls);
        return result != null ? result : mainSanitizer;
    }

    public static Sanitizer.ITransformer path(String target, String value) {
        if (!Strings.isNullOrEmpty((String)target)) {
            return new PathReplace(target, value);
        }
        return null;
    }

    public static Sanitizer.ITransformer pathNoDuplicate(String target, String value) {
        if (!Strings.isNullOrEmpty((String)target) && !ALREADY_REPLACED.contains(target)) {
            ALREADY_REPLACED.add(target);
            return new PathReplace(target, value);
        }
        return null;
    }

    public static Sanitizer.ITransformer replace(Object target, String value) {
        String s;
        if (target != null && (s = target.toString()) != null && s.length() > 2 && !DONT_REPLACE.contains(s)) {
            return new SimpleReplace(s, value);
        }
        return null;
    }

    public static Sanitizer.ITransformer replaceNoDuplicates(Object target, String value) {
        String s;
        if (target != null && (s = target.toString()) != null && s.length() > 2 && !ALREADY_REPLACED.contains(s) && !DONT_REPLACE.contains(s)) {
            ALREADY_REPLACED.add(s);
            return new SimpleReplace(s, value);
        }
        return null;
    }

    private static void addLocalAddresses() {
        HashSet ips = Sets.newHashSet();
        HashSet hosts = Sets.newHashSet();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface intf = interfaces.nextElement();
                Enumeration<InetAddress> addresses = intf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address == null) continue;
                    ips.add(address.getHostAddress());
                    String host = address.getHostName();
                    if (ips.contains(host)) continue;
                    hosts.add(host);
                }
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to get local IP adresses for sanitization", new Object[0]);
        }
        for (String ip : ips) {
            mainSanitizer.addPre(700, Sanitizers.replace(ip, "[local ip]"));
        }
        for (String host : hosts) {
            mainSanitizer.addPre(500, Sanitizers.replace(host, "[host]"));
        }
        mainSanitizer.addPre(600, new SimpleRegexReplace("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}[:~]\\d+", "[ip+port]"));
    }

    public static void addWorldNames(World world) {
        ISaveHandler saveHandler = world.func_72860_G();
        File worldDirectory = saveHandler.func_75765_b();
        if (worldDirectory != null) {
            String worldDir = worldDirectory.getName();
            mainSanitizer.addPre(900, Sanitizers.replaceNoDuplicates(worldDir, "[save dir]"));
        }
        try {
            String parent;
            File dummy = saveHandler.func_75758_b("dummy");
            if (dummy != null && (parent = dummy.getParentFile().getParent()) != null) {
                mainSanitizer.addPre(1300, Sanitizers.pathNoDuplicate(parent, "[save dir]"));
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to get sanitizer name for world", new Object[0]);
        }
        String worldName = world.func_72912_H().func_76065_j();
        mainSanitizer.addPre(800, Sanitizers.replaceNoDuplicates(worldName, "[world name]"));
    }

    public static void addMinecraftPath(File mcLocation) {
        mainSanitizer.addPre(1200, Sanitizers.path(mcLocation.getAbsolutePath(), "[minecraft_dir]"));
    }

    public static void addPlayerName(String username) {
        mainSanitizer.addPre(400, Sanitizers.replace(username, "[local player]"));
    }

    static {
        DONT_REPLACE.add("player");
        DONT_REPLACE.add("MpServer");
        DONT_REPLACE.add("none");
        DONT_REPLACE.add("null");
        THROWABLE_SANITIZERS = Maps.newHashMap();
        mainSanitizer = new Sanitizer();
        Sanitizers.addLocalAddresses();
        mainSanitizer.addPre(1100, new PathReplace(System.getProperty("user.dir"), "[workdir]"));
        mainSanitizer.addPre(1000, new PathReplace(System.getProperty("user.home"), "[home]"));
        mainSanitizer.addPre(100, new PropertyReplace("user.name", "[user]"));
        Sanitizer ipSanitizer = new Sanitizer(mainSanitizer);
        ipSanitizer.addPre(1000, new SimpleRegexReplace("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", "[ip]"));
        Sanitizers.addThrowableSanitizer(ProtocolException.class, ipSanitizer);
        Sanitizers.addThrowableSanitizer(UnknownHostException.class, ipSanitizer);
    }

    private static class SimpleRegexReplace
    implements Sanitizer.ITransformer {
        private final Pattern pattern;
        private final String replacement;

        public SimpleRegexReplace(String pattern, String replacement) {
            this.pattern = Pattern.compile(pattern);
            this.replacement = replacement;
        }

        @Override
        public String transform(String input) {
            Matcher match = this.pattern.matcher(input);
            return match.replaceAll(this.replacement);
        }

        public String toString() {
            return "regex: " + this.replacement;
        }
    }

    private static class PathReplace
    implements Sanitizer.ITransformer {
        private final String targetNormal;
        private final String targetReversed;
        private final String targetDoubled;
        private final String value;

        public PathReplace(String target, String value) {
            this.targetNormal = target;
            if (File.separatorChar == '\\') {
                this.targetReversed = this.targetNormal.replace('\\', '/');
                this.targetDoubled = this.targetNormal.replace("\\", "\\\\");
            } else if (File.separatorChar == '/') {
                this.targetReversed = this.targetNormal.replace('/', '\\');
                this.targetDoubled = this.targetNormal.replace("/", "\\\\");
            } else {
                this.targetReversed = null;
                this.targetDoubled = null;
            }
            this.value = value;
        }

        @Override
        public String transform(String input) {
            input = input.replace(this.targetNormal, this.value);
            if (this.targetReversed != null) {
                input = input.replace(this.targetReversed, this.value);
            }
            if (this.targetDoubled != null) {
                input = input.replace(this.targetDoubled, this.value);
            }
            return input;
        }

        public String toString() {
            return String.format("path '%s'->'%s'", this.targetNormal, this.value);
        }
    }

    private static class PropertyReplace
    extends SimpleReplace {
        public PropertyReplace(String property, String value) {
            super(System.getProperty(property), value);
        }
    }

    static class SimpleReplace
    implements Sanitizer.ITransformer {
        private final String target;
        private final String value;

        public SimpleReplace(String target, String value) {
            this.target = target;
            this.value = value;
        }

        @Override
        public String transform(String input) {
            return input.replace(this.target, this.value);
        }

        public String toString() {
            return String.format("'%s'->'%s'", this.target, this.value);
        }
    }
}

