/*
 * Decompiled with CFR 0.152.
 */
package openeye.asm.injectors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import openeye.Log;
import openeye.asm.CallHack;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ExceptionHandlerInjector
extends MethodVisitor {
    private final Method callTarget;
    private final Type callHackType;
    private final String[] excNames;
    private final Map<Label, String> excLabels = Maps.newIdentityHashMap();
    private final String excType;
    int currentLabel;
    private boolean skipHandlers;

    public ExceptionHandlerInjector(MethodVisitor mv, String excType, String ... excNames) {
        super(327680, mv);
        this.excNames = excNames;
        this.excType = excType;
        try {
            this.callHackType = Type.getType(CallHack.class);
            this.callTarget = Method.getMethod((java.lang.reflect.Method)CallHack.class.getMethod("callForSilentException", Throwable.class, String.class));
        }
        catch (NoSuchMethodException t) {
            throw new RuntimeException(t);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        if (!this.skipHandlers && this.excType.equals(type)) {
            try {
                String name = this.excNames[this.currentLabel++];
                String prev = this.excLabels.put(handler, name);
                Preconditions.checkState((prev == null || prev.equals(name) ? 1 : 0) != 0, (String)"Duplicate handlers for '%s'", (Object)name);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.warn("Invalid method structure, more than %d exception handlers. Aborting", this.excNames.length);
                this.skipHandlers = true;
            }
        }
    }

    public void visitLabel(Label label) {
        String name;
        super.visitLabel(label);
        if (!this.skipHandlers && (name = this.excLabels.get(label)) != null) {
            this.addHandler(name);
        }
    }

    private void addHandler(String location) {
        Log.debug("Adding handler for '%s'", location);
        super.visitInsn(89);
        super.visitLdcInsn((Object)location);
        super.visitMethodInsn(184, this.callHackType.getInternalName(), this.callTarget.getName(), this.callTarget.getDescriptor(), false);
    }
}

