/*
 * Decompiled with CFR 0.152.
 */
package openeye;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import openeye.Log;
import openeye.logic.Config;
import openeye.logic.Sanitizers;
import openeye.notes.NotesButtonInjector;

public abstract class Proxy {
    private static Proxy instance;

    public abstract boolean isSnooperEnabled();

    public abstract String getLanguage();

    public abstract void first();

    public abstract void init();

    public static Proxy instance() {
        if (instance == null) {
            instance = Proxy.createProxy();
        }
        return instance;
    }

    private static Proxy createProxy() {
        switch (FMLCommonHandler.instance().getSide()) {
            case CLIENT: {
                return new Client();
            }
            case SERVER: {
                return new Server();
            }
        }
        throw new IllegalStateException("Impossibru!");
    }

    private static class Server
    extends Proxy {
        private Server() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSnooperEnabled() {
            try {
                File settings = new File("server.properties");
                Properties props = new Properties();
                try (FileInputStream input = new FileInputStream(settings);){
                    props.load(input);
                }
                String flag = props.getProperty("snooper-enabled");
                return flag != null ? flag.equalsIgnoreCase("true") : true;
            }
            catch (Exception e) {
                Log.warn(e, "Can't read server snooper settings, won't send any data", new Object[0]);
                return false;
            }
        }

        @Override
        public String getLanguage() {
            return "n/a";
        }

        @Override
        public void first() {
        }

        @Override
        public void init() {
        }
    }

    private static class Client
    extends Proxy {
        private Client() {
        }

        @Override
        public boolean isSnooperEnabled() {
            try {
                return Minecraft.func_71410_x().field_71474_y.field_74355_t;
            }
            catch (Exception e) {
                Log.warn(e, "Can't read client snooper settings, won't send any data", new Object[0]);
                return false;
            }
        }

        @Override
        public String getLanguage() {
            return Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        }

        @Override
        public void first() {
            try {
                String username = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                if (!Strings.isNullOrEmpty((String)username)) {
                    Sanitizers.addPlayerName(username);
                }
            }
            catch (Throwable t) {
                Log.warn(t, "Failed to get player username", new Object[0]);
            }
        }

        @Override
        public void init() {
            if (Config.mainScreenNotes) {
                NotesButtonInjector.registerInjector();
            }
        }
    }
}

