/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryStatic
implements IInventory,
IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected NonNullList<ItemStack> stacks;

    public InventoryStatic(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    protected void onLoad() {
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74771_c("slot") & 0xFF;
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new ItemStack(itemTags));
        }
        this.onLoad();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("slot", (byte)i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        this.setStackInSlot(i, itemstack);
    }

    public boolean func_191420_l() {
        for (ItemStack item : this.stacks) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack insertItem(ItemStack paid, int start, int end, boolean simulate) {
        for (int i = start; i <= end; ++i) {
            paid = this.insertItem(i, paid, simulate);
        }
        return paid;
    }

    public ItemStack extractItem(ItemStack sold, int count, int start, int end, boolean simulate) {
        int expected = count;
        for (int i = start; i <= end; ++i) {
            if (!sold.func_77969_a(this.extractItem(i, count, true))) continue;
            count -= this.extractItem(i, count, simulate).func_190916_E();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)sold, (int)(expected - count));
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("", new Object[0]);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return false;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int amount) {
        return ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)amount);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack)) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    protected void validateSlotIndex(int slot) {
    }

    protected void onContentsChanged(int slot) {
    }
}

