/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.layouts;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.layouts.AbstractLayout;
import org.lwjgl.opengl.GL11;

public class LinearLayout
extends AbstractLayout {
    private int height;
    private int width;
    private boolean horizontal;

    public LinearLayout(int x, int y, boolean horizontal) {
        super(x, y, 0, 0);
        this.horizontal = horizontal;
    }

    @Override
    public void render() {
        if (this.getChildren() == null || this.hidden) {
            return;
        }
        int offset = 0;
        if (this.horizontal) {
            for (GuiElement e : this.getChildren()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                e.x = this.x + offset;
                e.y = this.y;
                if (e.center) {
                    e.y = this.y + this.getHeight() / 2 - e.getHeight() / 2;
                }
                e.render();
                int w = e.getWidth();
                offset += w + (w == 0 ? 0 : 6);
            }
        } else {
            for (GuiElement e : this.getChildren()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                e.x = this.x;
                if (e.center) {
                    e.x = this.x + this.getWidth() / 2 - e.getWidth() / 2;
                }
                e.y = this.y + offset;
                e.render();
                offset += e.getHeight();
            }
        }
    }

    @Override
    public int getHeight() {
        if (this.hidden) {
            return 0;
        }
        int s = 0;
        if (this.horizontal) {
            for (GuiElement guiElement : this.getChildren()) {
                if (s >= guiElement.getHeight()) continue;
                s = guiElement.getHeight();
            }
        } else {
            for (GuiElement guiElement : this.getChildren()) {
                s += guiElement.getHeight();
            }
        }
        return s;
    }

    @Override
    public int getWidth() {
        if (this.hidden) {
            return 0;
        }
        int s = 0;
        if (!this.horizontal) {
            for (GuiElement guiElement : this.getChildren()) {
                if (s >= guiElement.getWidth()) continue;
                s = guiElement.getWidth();
            }
        } else {
            for (GuiElement guiElement : this.getChildren()) {
                int w;
                s += w + ((w = guiElement.getWidth()) == 0 ? 0 : 6);
            }
            s -= 6;
        }
        return s;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }
}

