/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.elements;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiEdit;
import com.kamildanak.minecraft.foamflower.gui.input.InputKeyboardEvent;
import java.math.BigInteger;

public class GuiEditBigInteger
extends GuiEdit {
    private BigInteger value = BigInteger.valueOf(0L);
    private BigInteger min;
    private BigInteger max;

    public GuiEditBigInteger(int x, int y, int w, int h, BigInteger min, BigInteger max) {
        super(x, y, w, h);
        this.min = min;
        this.max = max;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.setText(this.value.toString());
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
        super.setText(value.toString());
    }

    @Override
    public void keyPressed(InputKeyboardEvent ev) {
        if (!this.field.func_146206_l()) {
            return;
        }
        if (Character.isDigit(ev.character)) {
            this.value = this.value.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(Character.getNumericValue(ev.character)));
        } else if (ev.character == '-') {
            this.value = this.value.negate();
        } else if (ev.character == '\b') {
            this.value = this.value.divide(BigInteger.valueOf(10L));
        }
        if (this.value.compareTo(this.min) < 0) {
            this.value = this.min;
        }
        if (this.value.compareTo(this.max) > 0) {
            this.value = this.max;
        }
        super.setText(this.value.toString());
        ev.handled = true;
    }

    @Override
    public int getHeight() {
        if (this.hidden) {
            return 0;
        }
        return this.h;
    }

    @Override
    public int getWidth() {
        if (this.hidden) {
            return 0;
        }
        return this.w;
    }
}

