/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.world.gen.dungeon;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.StructureComponent;
import stevekung.mods.moreplanets.util.MPLog;

public class DungeonConfigurationMP {
    private IBlockState brickBlock;
    private IBlockState glowstoneBlock;
    private IBlockState webBlock;
    private IBlockState torchBlock;
    private IBlockState ancientChestBlock;
    private int yPosition;
    private int hallwayLengthMin;
    private int hallwayLengthMax;
    private int hallwayHeight;
    private int roomHeight;
    private Class<? extends StructureComponent> bossRoom;
    private Class<? extends StructureComponent> treasureRoom;
    private Class<? extends StructureComponent> spawnerRoom;
    private Class<? extends StructureComponent> chestRoom;

    public DungeonConfigurationMP() {
    }

    public DungeonConfigurationMP(IBlockState brickBlock, IBlockState glowstoneBlock, IBlockState webBlock, IBlockState torchBlock, IBlockState ancientChestBlock, int yPosition, int hallwayLengthMin, int hallwayLengthMax, int hallwayHeight, int roomHeight, Class<? extends StructureComponent> bossRoom, Class<? extends StructureComponent> treasureRoom, Class<? extends StructureComponent> spawnerRoom, Class<? extends StructureComponent> chestRoom) {
        this.brickBlock = brickBlock;
        this.glowstoneBlock = glowstoneBlock;
        this.webBlock = webBlock;
        this.torchBlock = torchBlock;
        this.ancientChestBlock = ancientChestBlock;
        this.yPosition = yPosition;
        this.hallwayLengthMin = hallwayLengthMin;
        this.hallwayLengthMax = hallwayLengthMax;
        this.hallwayHeight = hallwayHeight;
        this.roomHeight = roomHeight;
        this.bossRoom = bossRoom;
        this.treasureRoom = treasureRoom;
        this.spawnerRoom = spawnerRoom;
        this.chestRoom = chestRoom;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("DungeonBrickBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.brickBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("DungeonBrickBlockMeta", this.brickBlock.func_177230_c().func_176201_c(this.brickBlock));
        tagCompound.func_74778_a("GlowstoneBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.glowstoneBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("GlowstoneBlockMeta", this.glowstoneBlock.func_177230_c().func_176201_c(this.glowstoneBlock));
        tagCompound.func_74778_a("WebBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.webBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("WebBlockMeta", this.webBlock.func_177230_c().func_176201_c(this.webBlock));
        tagCompound.func_74778_a("TorchBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.torchBlock.func_177230_c())).toString());
        tagCompound.func_74778_a("AncientChestBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.ancientChestBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("YPosition", this.yPosition);
        tagCompound.func_74768_a("HallwayLengthMin", this.hallwayLengthMin);
        tagCompound.func_74768_a("HallwayLengthMax", this.hallwayLengthMax);
        tagCompound.func_74768_a("HallwayHeight", this.hallwayHeight);
        tagCompound.func_74768_a("RoomHeight", this.roomHeight);
        tagCompound.func_74778_a("BossRoom", this.bossRoom.getName());
        tagCompound.func_74778_a("TreasureRoom", this.treasureRoom.getName());
        tagCompound.func_74778_a("SpawnerRoom", this.spawnerRoom.getName());
        tagCompound.func_74778_a("ChestRoom", this.chestRoom.getName());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        try {
            this.brickBlock = Block.func_149684_b((String)tagCompound.func_74779_i("DungeonBrickBlock")).func_176203_a(tagCompound.func_74762_e("DungeonBrickBlockMeta"));
            this.glowstoneBlock = Block.func_149684_b((String)tagCompound.func_74779_i("GlowstoneBlock")).func_176203_a(tagCompound.func_74762_e("GlowstoneBlockMeta"));
            this.webBlock = Block.func_149684_b((String)tagCompound.func_74779_i("WebBlock")).func_176203_a(tagCompound.func_74762_e("WebBlockMeta"));
            this.torchBlock = Block.func_149684_b((String)tagCompound.func_74779_i("TorchBlock")).func_176223_P();
            this.ancientChestBlock = Block.func_149684_b((String)tagCompound.func_74779_i("AncientChestBlock")).func_176223_P();
            this.yPosition = tagCompound.func_74762_e("YPosition");
            this.hallwayLengthMin = tagCompound.func_74762_e("HallwayLengthMin");
            this.hallwayLengthMax = tagCompound.func_74762_e("HallwayLengthMax");
            this.hallwayHeight = tagCompound.func_74762_e("HallwayHeight");
            this.roomHeight = tagCompound.func_74762_e("RoomHeight");
            this.bossRoom = Class.forName(tagCompound.func_74779_i("BossRoom"));
            this.treasureRoom = Class.forName(tagCompound.func_74779_i("TreasureRoom"));
            this.spawnerRoom = Class.forName(tagCompound.func_74779_i("SpawnerRoom"));
            this.chestRoom = Class.forName(tagCompound.func_74779_i("ChestRoom"));
        }
        catch (Exception e) {
            MPLog.error("Failed to read dungeon configuration from NBT");
            e.printStackTrace();
        }
    }

    public IBlockState getBrickBlock() {
        return this.brickBlock;
    }

    public IBlockState getGlowstoneBlock() {
        return this.glowstoneBlock;
    }

    public IBlockState getWebBlock() {
        return this.webBlock;
    }

    public IBlockState getTorchBlock() {
        return this.torchBlock;
    }

    public IBlockState getAncientChestBlock() {
        return this.ancientChestBlock;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getHallwayLengthMin() {
        return this.hallwayLengthMin;
    }

    public int getHallwayLengthMax() {
        return this.hallwayLengthMax;
    }

    public int getHallwayHeight() {
        return this.hallwayHeight;
    }

    public int getRoomHeight() {
        return this.roomHeight;
    }

    public Class<? extends StructureComponent> getBossRoom() {
        return this.bossRoom;
    }

    public Class<? extends StructureComponent> getTreasureRoom() {
        return this.treasureRoom;
    }

    public Class<? extends StructureComponent> getSpawnerRoom() {
        return this.spawnerRoom;
    }

    public Class<? extends StructureComponent> getChestRoom() {
        return this.chestRoom;
    }
}

