/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPSounds;

public class TileEntityTreasureChestMP
extends TileEntityAdvanced
implements IKeyable,
IInteractionObject,
ISidedInventory,
IInventoryDefaults {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private String name;
    private Block block;
    private ResourceLocation lootTable;
    private long lootTableSeed;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int tier = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean locked = true;

    public TileEntityTreasureChestMP(int tier, String name, Block block) {
        this.tier = tier;
        this.name = name;
        this.block = block;
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int index) {
        this.fillWithLoot(null);
        return (ItemStack)this.getItems().get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.fillWithLoot(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        this.fillWithLoot(null);
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.fillWithLoot(null);
        this.getItems().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.chestContents) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.chestContents;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)("container." + this.name + ".treasurechest.name"));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.locked = nbt.func_74767_n("isLocked");
        this.tier = nbt.func_74762_e("tier");
        if (!this.checkLootAndRead(nbt)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.chestContents);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isLocked", this.locked);
        nbt.func_74768_a("tier", this.tier);
        if (!this.checkLootAndWrite(nbt)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.chestContents);
        }
        return nbt;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        float f;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (this.locked) {
            this.numPlayersUsing = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - f), (double)((float)j - f), (double)((float)k - f), (double)((float)(i + 1) + f), (double)((float)(j + 1) + f), (double)((float)(k + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f2 = f = this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? 0.05f : 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.6f : this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if ((this.numPlayersUsing == 0 || this.locked) && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f22;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing == 0 || this.locked ? (this.lidAngle -= f) : (this.lidAngle += f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f22 = 0.5f) && f1 >= f22) {
                double d2 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d2, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.6f : this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        super.func_73660_a();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() == this.block) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public String func_174875_k() {
        return "moreplanets:treasure_chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.fillWithLoot(player);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, player);
    }

    public void func_174888_l() {
        this.fillWithLoot(null);
        this.getItems().clear();
    }

    public int getTierOfKeyRequired() {
        return this.tier;
    }

    public boolean onValidKeyActivated(EntityPlayer player, ItemStack key, EnumFacing facing) {
        if (this.locked) {
            this.locked = false;
            if (this.field_145850_b.field_72995_K) {
                player.func_184185_a(MPSounds.UNLOCK_TREASURE_CHEST, 1.0f, 1.0f);
            } else {
                if (!player.field_71075_bZ.field_75098_d && player.field_71071_by.func_70448_g().func_190916_E() == 0) {
                    player.field_71071_by.func_70448_g().func_190918_g(1);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
        }
        return false;
    }

    public boolean onActivatedWithoutKey(EntityPlayer player, EnumFacing facing) {
        if (this.locked) {
            if (player.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_FAILED_CHEST_UNLOCK, GCCoreUtil.getDimensionID((World)this.field_145850_b), new Object[]{this.getTierOfKeyRequired()}));
            }
            return true;
        }
        return false;
    }

    public boolean canBreak() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public double getPacketRange() {
        return 20.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    public int[] func_180463_a(EnumFacing facing) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    protected void fillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da());
            }
            loottable.func_186460_a((IInventory)this, random, lootcontext$builder.func_186471_a());
        }
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    public static TileEntityTreasureChestMP findClosest(Entity entity, int tier) {
        double distance = Double.MAX_VALUE;
        TileEntityTreasureChestMP chest = null;
        for (TileEntity tile : entity.field_70170_p.field_147482_g) {
            double dist;
            if (!(tile instanceof TileEntityTreasureChestMP) || ((TileEntityTreasureChestMP)tile).getTierOfKeyRequired() != tier || !((dist = entity.func_70092_e((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5)) < distance)) continue;
            distance = dist;
            chest = (TileEntityTreasureChestMP)tile;
        }
        return chest;
    }
}

