/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.helper;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.util.StackSorted;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.util.EnumHarvestLevel;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.blocks.ISortableBlock;
import stevekung.mods.moreplanets.util.entity.EnumEntityTrackerType;
import stevekung.mods.moreplanets.util.items.EnumSortCategoryItem;
import stevekung.mods.moreplanets.util.items.ISingleItemRender;
import stevekung.mods.moreplanets.util.items.ISortableItem;

public class CommonRegisterHelper {
    private static int ID = 0;
    public static Map<EnumSortCategoryBlock, List<StackSorted>> SORT_MAP_BLOCKS = new HashMap<EnumSortCategoryBlock, List<StackSorted>>();
    public static Map<EnumSortCategoryItem, List<StackSorted>> SORT_MAP_ITEMS = new HashMap<EnumSortCategoryItem, List<StackSorted>>();
    public static Map<Block, String> SINGLE_BLOCK_RENDER_LIST = new HashMap<Block, String>();
    public static Map<Item, String> SINGLE_ITEM_RENDER_LIST = new HashMap<Item, String>();

    public static void registerBlock(Block block) {
        CommonRegisterHelper.registerBlock(block, (Function<Block, ItemBlock>)((Function)ItemBlock::new));
    }

    public static void registerBlock(Block block, @Nullable Function<Block, ItemBlock> itemBlock) {
        ISingleBlockRender blockRender;
        String name = block.func_149739_a().substring(5);
        ForgeRegistries.BLOCKS.register(block.setRegistryName(name));
        if (block instanceof ISingleBlockRender && (blockRender = (ISingleBlockRender)block).getName() != null) {
            SINGLE_BLOCK_RENDER_LIST.put(block, blockRender.getName());
        }
        if (itemBlock != null) {
            ForgeRegistries.ITEMS.register(((ItemBlock)itemBlock.apply((Object)block)).setRegistryName(block.getRegistryName()));
            if (CommonRegisterHelper.isEffectiveClient()) {
                CommonRegisterHelper.registerSorted(block);
            }
        }
    }

    public static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
    }

    public static void registerItem(Item item) {
        ISingleItemRender itemRender;
        String name = item.func_77658_a().substring(5);
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        if (item instanceof ISingleItemRender && (itemRender = (ISingleItemRender)item).getName() != null) {
            SINGLE_ITEM_RENDER_LIST.put(item, itemRender.getName());
        }
        if (CommonRegisterHelper.isEffectiveClient()) {
            CommonRegisterHelper.registerSorted(item);
        }
    }

    public static void registerPotion(Potion potion, String name) {
        ForgeRegistries.POTIONS.register(potion.setRegistryName(name));
    }

    public static void registerBiome(Biome biome) {
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
    }

    public static void registerBiomeType(Biome biome, BiomeDictionary.Type ... biomeType) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeType);
    }

    public static SoundEvent registerSound(String name) {
        ForgeRegistries.SOUND_EVENTS.register(new SoundEvent(new ResourceLocation("moreplanets:" + name)).setRegistryName(new ResourceLocation("moreplanets:" + name)));
        return new SoundEvent(new ResourceLocation("moreplanets:" + name));
    }

    public static SoundEvent registerRecord(String name) {
        return CommonRegisterHelper.registerSound("record." + name);
    }

    public static ResourceLocation registerEntityLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("moreplanets:entities/" + name));
    }

    public static ResourceLocation registerEntityDyeLoot(String folder, String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("moreplanets:entities/" + folder + "/" + name));
    }

    public static ResourceLocation registerChestLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("moreplanets:chests/" + name));
    }

    public static ResourceLocation registerGameplayLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("moreplanets:gameplay/" + name));
    }

    public static ResourceLocation registerFishingLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("moreplanets:gameplay/fishing/" + name));
    }

    public static void registerTileEntity(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    public static void registerForgeBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static void registerGUIHandler(Object obj, IGuiHandler handler) {
        NetworkRegistry.INSTANCE.registerGuiHandler(obj, handler);
    }

    public static void setFireBurn(Block block, int encouragement, int flammibility) {
        Blocks.field_150480_ab.func_180686_a(block, encouragement, flammibility);
    }

    public static void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor) {
        CommonRegisterHelper.registerEntity(entity, name, backgroundColor, foregroundColor, EnumEntityTrackerType.NORMAL);
    }

    public static void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor, EnumEntityTrackerType type) {
        CommonRegisterHelper.registerEntity(entity, name, backgroundColor, foregroundColor, type.getTrackingRange(), type.getUpdateFrequency());
    }

    public static void registerEntity(Class<? extends Entity> entity, String name, int backgroundColor, int foregroundColor, int trackingRange, int updateFrequency) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("moreplanets:" + name), entity, (String)("moreplanets." + name), (int)ID++, (Object)"moreplanets", (int)trackingRange, (int)updateFrequency, (boolean)true, (int)backgroundColor, (int)foregroundColor);
    }

    public static void registerNonMobEntity(Class<? extends Entity> entity, String name) {
        CommonRegisterHelper.registerNonMobEntity(entity, name, EnumEntityTrackerType.NORMAL);
    }

    public static void registerNonMobEntity(Class<? extends Entity> entity, String name, EnumEntityTrackerType type) {
        CommonRegisterHelper.registerNonMobEntity(entity, name, type.getTrackingRange(), type.getUpdateFrequency());
    }

    public static void registerNonMobEntity(Class<? extends Entity> entity, String name, int trackingRange, int updateFrequency) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("moreplanets:" + name), entity, (String)name, (int)ID++, (Object)"moreplanets", (int)trackingRange, (int)updateFrequency, (boolean)true);
    }

    public static void registerEntityPlacement(Class<? extends Entity> entity, EntityLiving.SpawnPlacementType type) {
        EntitySpawnPlacementRegistry.setPlacementType(entity, (EntityLiving.SpawnPlacementType)type);
    }

    public static void registerCarriable(Block block) {
        EntityEnderman.setCarriable((Block)block, (boolean)true);
    }

    public static void setBlockHarvestLevel(Block block, EnumHarvestLevel harvestLevel, int level) {
        block.setHarvestLevel(harvestLevel.toString(), level);
    }

    public static void setBlockHarvestLevel(Block block, EnumHarvestLevel harvestLevel, int level, int meta) {
        block.setHarvestLevel(harvestLevel.toString(), level, block.func_176203_a(meta));
    }

    public static void setToolHarvestLevel(Item item, EnumHarvestLevel harvestLevel, int level) {
        item.setHarvestLevel(harvestLevel.toString(), level);
    }

    public static void registerOreDictionary(String name, Block block) {
        OreDictionary.registerOre((String)name, (Block)block);
    }

    public static void registerOreDictionary(String name, Item item) {
        OreDictionary.registerOre((String)name, (Item)item);
    }

    public static void registerOreDictionary(String name, ItemStack itemStack) {
        OreDictionary.registerOre((String)name, (ItemStack)itemStack);
    }

    public static void registerForgeEvent(Object event) {
        MinecraftForge.EVENT_BUS.register(event);
    }

    public static void registerProjectileDispense(Item item, IBehaviorDispenseItem projectile) {
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)projectile);
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    public static boolean isEffectiveClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static void registerSorted(Block block) {
        if (block instanceof ISortableBlock) {
            Item item = Item.func_150898_a((Block)block);
            if (item == Items.field_190931_a) {
                return;
            }
            ISortableBlock sortableBlock = (ISortableBlock)block;
            NonNullList blocks = NonNullList.func_191196_a();
            block.func_149666_a(null, blocks);
            for (ItemStack itemStack : blocks) {
                EnumSortCategoryBlock categoryBlock = sortableBlock.getBlockCategory(itemStack.func_77952_i());
                if (!SORT_MAP_BLOCKS.containsKey((Object)categoryBlock)) {
                    SORT_MAP_BLOCKS.put(categoryBlock, new ArrayList());
                }
                SORT_MAP_BLOCKS.get((Object)categoryBlock).add(new StackSorted(itemStack.func_77973_b(), itemStack.func_77952_i()));
            }
        } else if (block.func_149708_J() == MorePlanetsCore.BLOCK_TAB) {
            throw new RuntimeException(block.getClass() + " must inherit " + ISortableBlock.class.getSimpleName() + "!");
        }
    }

    public static void postRegisteredSortBlock() {
        ArrayList<StackSorted> itemOrderListBlocks = new ArrayList<StackSorted>();
        for (EnumSortCategoryBlock type : EnumSortCategoryBlock.valuesCached()) {
            List<StackSorted> stackSorteds = SORT_MAP_BLOCKS.get((Object)type);
            if (stackSorteds == null) continue;
            itemOrderListBlocks.addAll(stackSorteds);
        }
        Ordering tabSorterBlocks = Ordering.explicit(itemOrderListBlocks).onResultOf(input -> new StackSorted(input.func_77973_b(), input.func_77952_i()));
        MorePlanetsCore.BLOCK_TAB.setTabSorter((Comparator<ItemStack>)tabSorterBlocks);
    }

    public static void registerSorted(Item item) {
        if (item instanceof ISortableItem) {
            ISortableItem sortableItem = (ISortableItem)item;
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a((CreativeTabs)MorePlanetsCore.ITEM_TAB, items);
            for (ItemStack itemStack : items) {
                EnumSortCategoryItem categoryItem = sortableItem.getItemCategory(itemStack.func_77952_i());
                if (!SORT_MAP_ITEMS.containsKey((Object)categoryItem)) {
                    SORT_MAP_ITEMS.put(categoryItem, new ArrayList());
                }
                SORT_MAP_ITEMS.get((Object)categoryItem).add(new StackSorted(itemStack.func_77973_b(), itemStack.func_77952_i()));
            }
        } else if (item.func_77640_w() == MorePlanetsCore.ITEM_TAB) {
            throw new RuntimeException(item.getClass() + " must inherit " + ISortableItem.class.getSimpleName() + "!");
        }
    }

    public static void postRegisteredSortItem() {
        ArrayList<StackSorted> itemOrderListItems = new ArrayList<StackSorted>();
        for (EnumSortCategoryItem type : EnumSortCategoryItem.valuesCached()) {
            List<StackSorted> stackSorteds = SORT_MAP_ITEMS.get((Object)type);
            if (stackSorteds == null) continue;
            itemOrderListItems.addAll(stackSorteds);
        }
        Ordering tabSorterItems = Ordering.explicit(itemOrderListItems).onResultOf(input -> new StackSorted(input.func_77973_b(), input.func_77952_i()));
        MorePlanetsCore.ITEM_TAB.setTabSorter((Comparator<ItemStack>)tabSorterItems);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static boolean isItemTab(CreativeTabs creativeTabs) {
        return creativeTabs == MorePlanetsCore.ITEM_TAB || creativeTabs == CreativeTabs.field_78027_g;
    }
}

