/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.debug;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;

public class JSONRecipe {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static File ADVANCE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();
    private static final boolean ENABLE = false;

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = ConfigManagerMP.config.getConfigFile().toPath().resolve("../recipes/").toFile();
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    private static void setupAdvDir() {
        if (ADVANCE_DIR == null) {
            ADVANCE_DIR = ConfigManagerMP.config.getConfigFile().toPath().resolve("../advancements/").toFile();
        }
        if (!ADVANCE_DIR.exists()) {
            ADVANCE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack output, Object ... components) {
    }

    public static void addShapelessRecipe(ItemStack output, Object ... components) {
    }

    private static Map<String, Object> serializeItem(Object obj) {
        if (obj instanceof Item) {
            return JSONRecipe.serializeItem(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return JSONRecipe.serializeItem(new ItemStack((Block)obj));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            if (itemStack.func_77942_o()) {
                ret.put("type", "minecraft:item_nbt");
            }
            ret.put("item", itemStack.func_77973_b().getRegistryName().toString());
            if (itemStack.func_77973_b().func_77614_k() || itemStack.func_77952_i() != 0) {
                ret.put("data", itemStack.func_77952_i());
            }
            if (itemStack.func_77942_o()) {
                ret.put("nbt", itemStack.func_77978_p().toString());
            }
            if (itemStack.func_190916_E() > 1) {
                ret.put("count", itemStack.func_190916_E());
            }
            return ret;
        }
        if (obj instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)obj);
            ret.put("item", "#" + ((String)obj).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public static void writeAdvancements(String result) {
    }

    public static void generateConstants() {
        JSONRecipe.setupDir();
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

