/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;

public class BlockVinesMP
extends BlockBaseMP
implements IShearable {
    public static PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    protected static AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockVinesMP(String name) {
        super(Material.field_151582_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.setSoundType(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
        this.func_149663_c(name);
    }

    public BlockVinesMP() {
        super(Material.field_151582_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.setSoundType(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177984_a()).func_185898_k()));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = field_185505_j;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            axisalignedbb = UP_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            axisalignedbb = NORTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            axisalignedbb = EAST_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            axisalignedbb = SOUTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            axisalignedbb = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisalignedbb : field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return this.canAttachVineOn(world.func_180495_p(pos.func_177984_a()));
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return this.canAttachVineOn(world.func_180495_p(pos.func_177972_a(side.func_176734_d())));
            }
        }
        return false;
    }

    private boolean canAttachVineOn(IBlockState state) {
        return state.func_185917_h() && state.func_185904_a().func_76230_c();
    }

    private boolean recheckGrownSides(World world, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = state;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = BlockVinesMP.getPropertyFor(enumfacing);
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue() || this.canAttachVineOn(world.func_180495_p(pos.func_177972_a(enumfacing))) || (iblockstate1 = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this && ((Boolean)iblockstate1.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)propertybool, (Comparable)Boolean.valueOf(false));
        }
        if (this.getNumGrownFaces(state) == 0) {
            return false;
        }
        if (iblockstate != state) {
            world.func_180501_a(pos, state, 2);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K && !this.recheckGrownSides(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.field_73012_v.nextInt(4) == 0) {
            int i = 4;
            int j = 5;
            boolean flag = false;
            block0: for (int k = -i; k <= i; ++k) {
                for (int l = -i; l <= i; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        if (world.func_180495_p(pos.func_177982_a(k, i1, l)).func_177230_c() != this || --j > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            EnumFacing enumfacing1 = EnumFacing.func_176741_a((Random)rand);
            BlockPos blockpos1 = pos.func_177984_a();
            if (enumfacing1 == EnumFacing.UP && pos.func_177956_o() < 255 && world.func_175623_d(blockpos1)) {
                if (!flag) {
                    IBlockState iblockstate2 = state;
                    for (EnumFacing enumfacing3 : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean() && this.canAttachVineOn(world.func_180495_p(blockpos1.func_177972_a(enumfacing3)))) continue;
                        iblockstate2 = iblockstate2.func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing3), (Comparable)Boolean.valueOf(false));
                    }
                    if (((Boolean)iblockstate2.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)WEST)).booleanValue()) {
                        world.func_180501_a(blockpos1, iblockstate2, 2);
                    }
                }
            } else if (enumfacing1.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)BlockVinesMP.getPropertyFor(enumfacing1))).booleanValue()) {
                if (!flag) {
                    BlockPos blockpos3 = pos.func_177972_a(enumfacing1);
                    if (world.func_180495_p(blockpos3).func_185904_a() == Material.field_151579_a) {
                        EnumFacing enumfacing2 = enumfacing1.func_176746_e();
                        EnumFacing enumfacing4 = enumfacing1.func_176735_f();
                        boolean flag1 = (Boolean)state.func_177229_b((IProperty)BlockVinesMP.getPropertyFor(enumfacing2));
                        boolean flag2 = (Boolean)state.func_177229_b((IProperty)BlockVinesMP.getPropertyFor(enumfacing4));
                        BlockPos blockpos4 = blockpos3.func_177972_a(enumfacing2);
                        BlockPos blockpos = blockpos3.func_177972_a(enumfacing4);
                        if (flag1 && this.canAttachVineOn(world.func_180495_p(blockpos4))) {
                            world.func_180501_a(blockpos3, this.func_176223_P().func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing2), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (flag2 && this.canAttachVineOn(world.func_180495_p(blockpos))) {
                            world.func_180501_a(blockpos3, this.func_176223_P().func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing4), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (flag1 && world.func_175623_d(blockpos4) && this.canAttachVineOn(world.func_180495_p(pos.func_177972_a(enumfacing2)))) {
                            world.func_180501_a(blockpos4, this.func_176223_P().func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing1.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (flag2 && world.func_175623_d(blockpos) && this.canAttachVineOn(world.func_180495_p(pos.func_177972_a(enumfacing4)))) {
                            world.func_180501_a(blockpos, this.func_176223_P().func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing1.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (this.canAttachVineOn(world.func_180495_p(blockpos3.func_177984_a()))) {
                            world.func_180501_a(blockpos3, this.func_176223_P(), 2);
                        }
                    } else if (world.func_180495_p(blockpos3).func_185904_a().func_76218_k() && world.func_180495_p(blockpos3).func_185917_h()) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing1), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else if (pos.func_177956_o() > 1) {
                BlockPos blockpos2 = pos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos2);
                Block block = iblockstate.func_177230_c();
                if (iblockstate.func_185904_a() == Material.field_151579_a) {
                    IBlockState iblockstate1 = state;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean()) continue;
                        iblockstate1 = iblockstate1.func_177226_a((IProperty)BlockVinesMP.getPropertyFor(enumfacing), (Comparable)Boolean.valueOf(false));
                    }
                    if (((Boolean)iblockstate1.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)WEST)).booleanValue()) {
                        world.func_180501_a(blockpos2, iblockstate1, 2);
                    }
                } else if (block == this) {
                    IBlockState iblockstate3 = iblockstate;
                    for (EnumFacing enumfacing5 : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool propertybool = BlockVinesMP.getPropertyFor(enumfacing5);
                        if (!rand.nextBoolean() || !((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
                        iblockstate3 = iblockstate3.func_177226_a((IProperty)propertybool, (Comparable)Boolean.valueOf(true));
                    }
                    if (((Boolean)iblockstate3.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate3.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate3.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate3.func_177229_b((IProperty)WEST)).booleanValue()) {
                        world.func_180501_a(blockpos2, iblockstate3, 2);
                    }
                }
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false));
        return facing.func_176740_k().func_176722_c() ? iblockstate.func_177226_a((IProperty)BlockVinesMP.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)) : iblockstate;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    private int getNumGrownFaces(IBlockState state) {
        int i = 0;
        for (PropertyBool propertybool : ALL_FACES) {
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((Block)this, 1));
    }
}

