/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util;

import java.lang.reflect.Method;
import net.minecraftforge.fml.common.Loader;
import stevekung.mods.moreplanets.util.MPLog;

public class CompatibilityManagerMP {
    public static final String baublesModId = "baubles";
    public static final boolean isCTMLoaded = Loader.isModLoaded((String)"ctm");
    public static final boolean isBigReactorLoaded = Loader.isModLoaded((String)"bigreactors");
    public static final boolean isOpenBlocksLoaded = Loader.isModLoaded((String)"openblocks");
    public static final boolean isEnderIOLoaded = Loader.isModLoaded((String)"enderio");
    public static final boolean isMobGrindingUtilsLoaded = Loader.isModLoaded((String)"mob_grinding_utils");
    public static final boolean isCCLLoaded = Loader.isModLoaded((String)"codechickenlib");
    public static final boolean isBaubleLoaded = Loader.isModLoaded((String)"baubles");
    private static Method erRegisterFluid;
    private static float conductivityEmerald;
    private static float conductivityCopper;
    private static float conductivityGold;

    public static void init() {
        if (isCTMLoaded) {
            MPLog.info("Enabled CTM integrations");
        }
        if (isBigReactorLoaded) {
            CompatibilityManagerMP.initBigReactorCompat();
            CompatibilityManagerMP.registerExtremeReactorFluid("infected_water_fluid", 0.45f, 0.925f, 1.25f, conductivityCopper);
            CompatibilityManagerMP.registerExtremeReactorFluid("purify_water_fluid", 0.525f, 0.75f, 4.0f, conductivityEmerald);
            CompatibilityManagerMP.registerExtremeReactorFluid("cheese_of_milk_fluid", 0.675f, 0.575f, 1.95f, conductivityGold);
            CompatibilityManagerMP.registerExtremeReactorFluid("crystallize_water_fluid", 0.3f, 0.65f, 2.45f, conductivityCopper);
        }
    }

    public static boolean isModAddedXpFluid() {
        return !isOpenBlocksLoaded && !isEnderIOLoaded && !isMobGrindingUtilsLoaded;
    }

    public static void registerExtremeReactorFluid(String name, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        MPLog.info("Registering %s into reactor interior", name);
        try {
            erRegisterFluid.invoke(null, name, Float.valueOf(absorption), Float.valueOf(heatEfficiency), Float.valueOf(moderation), Float.valueOf(heatConductivity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initBigReactorCompat() {
        MPLog.info("Enabled Extreme Reactors integrations");
        try {
            Class<?> reactorInterior = Class.forName("erogenousbeef.bigreactors.api.registry.ReactorInterior");
            Class<?> iHeatEntity = Class.forName("erogenousbeef.bigreactors.api.IHeatEntity");
            erRegisterFluid = reactorInterior.getDeclaredMethod("registerFluid", String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            conductivityEmerald = iHeatEntity.getDeclaredField("conductivityEmerald").getFloat(iHeatEntity);
            conductivityCopper = iHeatEntity.getDeclaredField("conductivityCopper").getFloat(iHeatEntity);
            conductivityGold = iHeatEntity.getDeclaredField("conductivityGold").getFloat(iHeatEntity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

