/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import stevekung.mods.moreplanets.blocks.BlockRocketCrusher;
import stevekung.mods.moreplanets.recipe.RocketCrusherRecipes;
import stevekung.mods.moreplanets.util.recipes.ShapedRecipesMP;

public class TileEntityRocketCrusher
extends TileBaseElectricBlock
implements IInventoryDefaults,
ISidedInventory {
    public static int PROCESS_TIME_REQUIRED_BASE = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED_BASE;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private long ticks;
    public NonNullList<ItemStack> containingItems = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public PersistantInventoryCrafting compressingCraftMatrix = new PersistantInventoryCrafting();

    public TileEntityRocketCrusher() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 125.0f : 100.0f);
        this.setTierGC(3);
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int speed;
            boolean updateInv = false;
            int n = speed = !((ItemStack)this.containingItems.get(2)).func_190926_b() ? 1 + ((ItemStack)this.containingItems.get(2)).func_190916_E() : 1;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    ++this.processTicks;
                    this.processTimeRequired = PROCESS_TIME_REQUIRED_BASE * 2 / (1 + this.poweredByTierGC) / speed;
                    if (this.processTicks % 45 - speed == 0) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, 0.5f);
                    }
                    if (this.processTicks >= this.processTimeRequired) {
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 0L;
        }
        ++this.ticks;
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.containingItems.get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.containingItems.get(1)).func_190926_b() && !((ItemStack)this.containingItems.get(1)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.containingItems.get(1)).func_190926_b() ? 0 : ((ItemStack)this.containingItems.get(1)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void updateInput() {
        this.producingStack = RocketCrusherRecipes.findMatchingRecipe((IInventory)this.compressingCraftMatrix);
    }

    public void compressItems() {
        this.compressIntoSlot(1);
    }

    private void compressIntoSlot(int slot) {
        if (this.canCompress()) {
            int i;
            ItemStack resultItemStack = this.producingStack.func_77946_l();
            if (((ItemStack)this.containingItems.get(slot)).func_190926_b()) {
                this.containingItems.set(slot, (Object)resultItemStack);
            } else if (((ItemStack)this.containingItems.get(slot)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.containingItems.get(slot)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    for (i = 0; i < ((ItemStack)this.containingItems.get(slot)).func_190916_E() + resultItemStack.func_190916_E() - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77952_i()));
                        entityitem.func_174867_a(10);
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                    ((ItemStack)this.containingItems.get(slot)).func_190920_e(64);
                } else {
                    ((ItemStack)this.containingItems.get(slot)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            for (i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
                this.compressingCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("ProcessTicks");
        this.containingItems = NonNullList.func_191197_a((int)(this.func_70302_i_() - this.compressingCraftMatrix.func_70302_i_()), (Object)ItemStack.field_190927_a);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < this.containingItems.size()) {
                this.containingItems.set(j, (Object)new ItemStack(nbttagcompound));
                continue;
            }
            if (j >= this.containingItems.size() + this.compressingCraftMatrix.func_70302_i_()) continue;
            this.compressingCraftMatrix.func_70299_a(j - this.containingItems.size(), new ItemStack(nbttagcompound));
        }
        this.updateInput();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound compound;
        int i;
        super.func_189515_b(nbt);
        nbt.func_74768_a("ProcessTicks", this.processTicks);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.containingItems.size(); ++i) {
            if (((ItemStack)this.containingItems.get(i)).func_190926_b()) continue;
            compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.containingItems.get(i)).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        for (i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
            if (this.compressingCraftMatrix.func_70301_a(i).func_190926_b()) continue;
            compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)(i + this.containingItems.size()));
            this.compressingCraftMatrix.func_70301_a(i).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return nbt;
    }

    public int func_70302_i_() {
        return this.containingItems.size() + this.compressingCraftMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.containingItems.size()) {
            return this.compressingCraftMatrix.func_70301_a(slot - this.containingItems.size());
        }
        return (ItemStack)this.containingItems.get(slot);
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (slot >= this.containingItems.size()) {
            ItemStack result = this.compressingCraftMatrix.func_70298_a(slot - this.containingItems.size(), size);
            if (!result.func_190926_b()) {
                this.updateInput();
            }
            this.func_70296_d();
            return result;
        }
        if (!((ItemStack)this.containingItems.get(slot)).func_190926_b()) {
            if (((ItemStack)this.containingItems.get(slot)).func_190916_E() <= size) {
                ItemStack itemStack = (ItemStack)this.containingItems.get(slot);
                this.containingItems.set(slot, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.containingItems.get(slot)).func_77979_a(size);
            if (((ItemStack)this.containingItems.get(slot)).func_190926_b()) {
                this.containingItems.set(slot, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index >= this.containingItems.size()) {
            this.func_70296_d();
            return this.compressingCraftMatrix.func_70304_b(index - this.containingItems.size());
        }
        if (!((ItemStack)this.containingItems.get(index)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)this.containingItems.get(index);
            this.containingItems.set(index, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.containingItems.size()) {
            this.compressingCraftMatrix.func_70299_a(slot - this.containingItems.size(), itemStack);
            this.updateInput();
        } else {
            this.containingItems.set(slot, (Object)itemStack);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
                itemStack.func_190920_e(this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.rocket_crusher.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return !itemStack.func_190926_b() && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        if (slot >= 3) {
            if (!this.producingStack.func_190926_b()) {
                ItemStack stackInSlot = this.func_70301_a(slot);
                return !stackInSlot.func_190926_b() && stackInSlot.func_77969_a(itemStack);
            }
            return this.isItemCompressorInput(itemStack, slot - 3);
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1, 2};
        }
        int[] slots = new int[]{0, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        block0: for (int i = 3; i < 12; ++i) {
            ItemStack stack1;
            if (removeSlots.contains(i) || (stack1 = this.func_70301_a(i)).func_190926_b() || stack1.func_190916_E() <= 0) continue;
            for (int j = i + 1; j < 12; ++j) {
                ItemStack stack2;
                if (removeSlots.contains(j) || (stack2 = this.func_70301_a(j)).func_190926_b() || !stack1.func_77969_a(stack2)) continue;
                if (stack2.func_190916_E() >= stack1.func_190916_E()) {
                    removeSlots.add(j);
                    continue block0;
                }
                removeSlots.add(i);
                continue block0;
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[slots.length - removeSlots.size()];
            int j = 0;
            for (int i = 0; i < slots.length; ++i) {
                if (i > 0 && removeSlots.contains(slots[i])) continue;
                returnSlots[j] = slots[i];
                ++j;
            }
            return returnSlots;
        }
        return slots;
    }

    public void slowDischarge() {
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return slot == 1 || slot == 2;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public EnumFacing getFront() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockRocketCrusher.FACING);
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    private boolean isItemCompressorInput(ItemStack itemStack, int id) {
        for (IRecipe recipe : RocketCrusherRecipes.getRecipeList()) {
            if (!(recipe instanceof ShapedRecipesMP) || id >= ((ShapedRecipesMP)recipe).recipeItems.length) continue;
            ItemStack itemstack1 = ((ShapedRecipesMP)recipe).recipeItems[id];
            if (itemStack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77952_i() != Short.MAX_VALUE && itemStack.func_77952_i() != itemstack1.func_77952_i()) continue;
            for (int i = 0; i < ((ShapedRecipesMP)recipe).recipeItems.length; ++i) {
                if (i == id) continue;
                ItemStack itemstack2 = ((ShapedRecipesMP)recipe).recipeItems[i];
                if (itemStack.func_77973_b() != itemstack2.func_77973_b() || itemstack2.func_77952_i() != Short.MAX_VALUE && itemStack.func_77952_i() != itemstack2.func_77952_i()) continue;
                ItemStack is3 = this.func_70301_a(id + 3);
                ItemStack is4 = this.func_70301_a(i + 3);
                return is3 == ItemStack.field_190927_a || is4 != ItemStack.field_190927_a && is3.func_190916_E() < is4.func_190916_E();
            }
            return true;
        }
        return false;
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.containingItems) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

