/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.client.gui.GuiShieldGenerator;
import stevekung.mods.moreplanets.client.gui.GuiShieldGeneratorConfig;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.inventory.ContainerShieldGeneratorConfig;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.TeleportUtil;
import stevekung.mods.moreplanets.util.helper.WorldDimensionHelper;

public class PacketSimpleMP
extends PacketBase {
    private EnumSimplePacketMP type;
    private List<Object> data;

    public PacketSimpleMP() {
    }

    public PacketSimpleMP(EnumSimplePacketMP packetType, int dimID, Object ... data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public PacketSimpleMP(EnumSimplePacketMP packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            MPLog.warning("More Planets Simple Packet found data length different than packet type: {}", packetType.name());
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacketMP.valuesCached()[buffer.readInt()];
        if (this.type.getDecodeClasses().length > 0) {
            this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        switch (this.type) {
            case C_ADD_ENTITY_ID: {
                String entityIDAdd = (String)this.data.get(0);
                if (ClientEventHandler.entityId.contains(entityIDAdd)) break;
                ClientEventHandler.entityId.add(entityIDAdd);
                break;
            }
            case C_REMOVE_ENTITY_ID: {
                String entityIDRemove = (String)this.data.get(0);
                ClientEventHandler.entityId.remove(entityIDRemove);
                break;
            }
            case C_REMOVE_GUIDE_POS: {
                BlockPos pos = (BlockPos)this.data.get(0);
                ClientEventHandler.receiverRenderPos.remove(pos);
                break;
            }
            case C_RELOAD_RENDERER: {
                ClientEventHandler.loadRenderers = true;
                break;
            }
            case C_SWITCH_SHIELD_GENERATOR_GUI: {
                BlockPos pos = (BlockPos)this.data.get(0);
                boolean isConfig = (Boolean)this.data.get(2);
                if (pos == null) break;
                TileEntity tile = player.field_70170_p.func_175625_s(pos);
                if (tile != null && tile instanceof TileEntityShieldGenerator) {
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)(isConfig ? new GuiShieldGeneratorConfig(player.field_71071_by, (TileEntityShieldGenerator)tile) : new GuiShieldGenerator(player.field_71071_by, (TileEntityShieldGenerator)tile)));
                }
                player.field_71070_bA.field_75152_c = (Integer)this.data.get(1);
                break;
            }
            case C_REMOVE_GENERATOR_GUIDE_POS: {
                BlockPos pos = (BlockPos)this.data.get(0);
                ClientEventHandler.wasteRenderPos.remove(pos);
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerMP = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        World world = player.field_70170_p;
        switch (this.type) {
            case S_FIRE_EXTINGUISH: {
                BlockPos pos = (BlockPos)this.data.get(0);
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                world.func_175698_g(pos);
                break;
            }
            case S_RESPAWN_PLAYER_NETHER: {
                if (!(world instanceof WorldServer)) break;
                WorldServer worldOld = (WorldServer)world;
                WorldServer worldNew = WorldDimensionHelper.getStartWorld(worldOld);
                BlockPos spawnPos = worldNew.func_175672_r(worldNew.func_175694_M());
                TeleportUtil.setWarpDimension(playerMP, worldNew, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), WorldUtil.getProviderForNameServer((String)WorldTickEventHandler.startedDimensionData.planetToBack).getDimension(), true);
                player.func_71004_bE();
                player.func_71053_j();
                break;
            }
            case S_BLACK_HOLE_STORAGE_OPTION: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                String type = (String)this.data.get(1);
                if (!(tile instanceof TileEntityBlackHoleStorage)) break;
                TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
                switch (type) {
                    case "disable": {
                        storage.disableBlackHole = !storage.disableBlackHole;
                        break;
                    }
                    case "collect_mode": {
                        ++storage.modeInt;
                        storage.modeInt %= 3;
                        switch (storage.modeInt) {
                            case 0: {
                                storage.collectMode = "item";
                                break;
                            }
                            case 1: {
                                storage.collectMode = "xp";
                                break;
                            }
                            case 2: {
                                storage.collectMode = "item_and_xp";
                            }
                        }
                        break;
                    }
                    case "use_hopper": {
                        storage.useHopper = !storage.useHopper;
                    }
                }
                break;
            }
            case S_SHIELD_VISIBLE: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.setBubbleVisible((Boolean)this.data.get(1));
                break;
            }
            case S_ENABLE_SHIELD: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.enableShield = !shield.enableShield;
                break;
            }
            case S_ENABLE_SHIELD_DAMAGE: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.enableDamage = !shield.enableDamage;
                break;
            }
            case S_SHIELD_GENERATOR_OPTION: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                int value = (Integer)this.data.get(1);
                String type = (String)this.data.get(2);
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                switch (type) {
                    case "damage": {
                        shield.shieldDamage = value;
                        break;
                    }
                    case "size": {
                        shield.maxShieldSize = value;
                    }
                }
                break;
            }
            case S_SWITCH_SHIELD_GENERATOR_GUI: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                boolean isConfig = (Boolean)this.data.get(1);
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                PacketSimpleMP.openShieldGeneratorConfig(playerMP, shield, isConfig);
                break;
            }
        }
    }

    public static void sendToAllAround(PacketSimpleMP packet, World world, int dimID, BlockPos pos, double radius) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double r2 = radius * radius;
        for (EntityPlayer player : world.field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (playerMP.field_71093_bK != dimID || !((dx = x - playerMP.field_70165_t) * dx + (dy = y - playerMP.field_70163_u) * dy + (dz = z - playerMP.field_70161_v) * dz < r2)) continue;
            GalacticraftCore.packetPipeline.sendTo((IPacket)packet, playerMP);
        }
    }

    private static void openShieldGeneratorConfig(EntityPlayerMP player, TileEntityShieldGenerator tile, boolean isConfig) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(EnumSimplePacketMP.C_SWITCH_SHIELD_GENERATOR_GUI, GCCoreUtil.getDimensionID((World)player.field_70170_p), tile.func_174877_v(), windowId, isConfig), player);
        player.field_71070_bA = new ContainerShieldGeneratorConfig(player.field_71071_by, tile);
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    public static enum EnumSimplePacketMP {
        S_FIRE_EXTINGUISH(Side.SERVER, BlockPos.class),
        S_RESPAWN_PLAYER_NETHER(Side.SERVER, new Class[0]),
        S_BLACK_HOLE_STORAGE_OPTION(Side.SERVER, BlockPos.class, String.class),
        S_SHIELD_VISIBLE(Side.SERVER, BlockPos.class, Boolean.class),
        S_ENABLE_SHIELD(Side.SERVER, BlockPos.class),
        S_ENABLE_SHIELD_DAMAGE(Side.SERVER, BlockPos.class),
        S_SHIELD_GENERATOR_OPTION(Side.SERVER, BlockPos.class, Integer.class, String.class),
        S_SWITCH_SHIELD_GENERATOR_GUI(Side.SERVER, BlockPos.class, Boolean.class),
        C_ADD_ENTITY_ID(Side.CLIENT, String.class),
        C_REMOVE_ENTITY_ID(Side.CLIENT, String.class),
        C_REMOVE_GUIDE_POS(Side.CLIENT, BlockPos.class),
        C_RELOAD_RENDERER(Side.CLIENT, new Class[0]),
        C_SWITCH_SHIELD_GENERATOR_GUI(Side.CLIENT, BlockPos.class, Integer.class, Boolean.class),
        C_REMOVE_GENERATOR_GUIDE_POS(Side.CLIENT, BlockPos.class);

        private Side targetSide;
        private Class[] decodeAs;
        private static EnumSimplePacketMP[] values;

        private EnumSimplePacketMP(Side targetSide, Class ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class[] getDecodeClasses() {
            return this.decodeAs;
        }

        public static EnumSimplePacketMP[] valuesCached() {
            return values;
        }

        static {
            values = EnumSimplePacketMP.values();
        }
    }
}

