/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureOceanMonumentPieces;
import net.minecraft.world.gen.structure.StructureStart;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityInfectedGuardian;
import stevekung.mods.moreplanets.util.MPLog;

public class MapGenNibiruOceanMonument
extends MapGenStructure {
    private int spacing = 32;
    private int separation = 5;
    public List<Biome> waterBiomes = new ArrayList<Biome>(Arrays.asList(MPBiomes.INFECTED_OCEAN, MPBiomes.INFECTED_DEEP_OCEAN, MPBiomes.INFECTED_RIVER));
    public Biome spawnBiome = MPBiomes.INFECTED_DEEP_OCEAN;
    private static List<Biome.SpawnListEntry> MONUMENT_ENEMIES = new ArrayList<Biome.SpawnListEntry>();

    public String func_143025_a() {
        return "NibiruOceanMonument";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int k = chunkX / this.spacing;
        int l = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387313);
        k *= this.spacing;
        l *= this.spacing;
        if (i == (k += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && j == (l += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            if (!this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 16, new ArrayList<Biome>(Arrays.asList(this.spawnBiome)))) {
                return false;
            }
            boolean flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 29, this.waterBiomes);
            if (flag) {
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new StartMonument(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenStructure.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    public List<Biome.SpawnListEntry> getSpawnList() {
        return MONUMENT_ENEMIES;
    }

    static {
        MONUMENT_ENEMIES.add(new Biome.SpawnListEntry(EntityInfectedGuardian.class, 1, 2, 4));
        MapGenStructureIO.func_143034_b(StartMonument.class, (String)"NibiruOceanMonument");
        StructureOceanMonumentPieces.func_175970_a();
    }

    public static class StartMonument
    extends StructureStart {
        private Set<ChunkPos> processed = new HashSet<ChunkPos>();
        private boolean wasCreated;

        public StartMonument() {
        }

        public StartMonument(World world, Random rand, int x, int z) {
            super(x, z);
            MPLog.debug("Generate Nibiru Ocean Monument at x:{} z:{}", x * 16, z * 16);
            this.create(world, rand, x, z);
        }

        private void create(World world, Random rand, int x, int z) {
            rand.setSeed(world.func_72905_C());
            long i = rand.nextLong();
            long j = rand.nextLong();
            long k = (long)x * i;
            long l = (long)z * j;
            rand.setSeed(k ^ l ^ world.func_72905_C());
            int i1 = x * 16 + 8 - 29;
            int j1 = z * 16 + 8 - 29;
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            this.field_75075_a.add(new StructureOceanMonumentPieces.MonumentBuilding(rand, i1, j1, enumfacing));
            this.func_75072_c();
            this.wasCreated = true;
        }

        public void func_75068_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.wasCreated) {
                this.field_75075_a.clear();
                this.create(world, rand, this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(world, rand, box);
        }

        public boolean func_175788_a(ChunkPos pair) {
            return this.processed.contains(pair) ? false : super.func_175788_a(pair);
        }

        public void func_175787_b(ChunkPos pair) {
            super.func_175787_b(pair);
            this.processed.add(pair);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (ChunkPos chunkpos : this.processed) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("X", chunkpos.field_77276_a);
                nbttagcompound.func_74768_a("Z", chunkpos.field_77275_b);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            tagCompound.func_74782_a("Processed", (NBTBase)nbttaglist);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            if (tagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nbttaglist = tagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.processed.add(new ChunkPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Z")));
                }
            }
        }
    }
}

