/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;

public abstract class WorldGenHugeTreesMP
extends WorldGenAbstractTree {
    private boolean genLeaves;
    private int baseHeight;
    private int extraRandomHeight;

    public WorldGenHugeTreesMP(boolean genLeaves, int baseHeight, int extraRandomHeight) {
        super(false);
        this.genLeaves = genLeaves;
        this.baseHeight = baseHeight;
        this.extraRandomHeight = extraRandomHeight;
    }

    protected int getHeight(Random rand) {
        int i = rand.nextInt(3) + this.baseHeight;
        if (this.extraRandomHeight > 1) {
            i += rand.nextInt(this.extraRandomHeight);
        }
        return i;
    }

    private boolean isSpaceAt(World world, BlockPos pos, int height) {
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (pos.func_177956_o() + i >= 0 && pos.func_177956_o() + i < 256 && this.isReplaceable(world, pos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureDirtsUnderneath(BlockPos pos, World world) {
        BlockPos blockpos = pos.func_177977_b();
        Block block = world.func_180495_p(blockpos).func_177230_c();
        if (block == NibiruBlocks.INFECTED_GRASS || block == NibiruBlocks.INFECTED_DIRT || block == NibiruBlocks.INFECTED_FARMLAND && pos.func_177956_o() >= 2) {
            this.onPlantGrow(world, blockpos, pos);
            this.onPlantGrow(world, blockpos.func_177974_f(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d().func_177974_f(), pos);
            return true;
        }
        return false;
    }

    protected boolean ensureGrowable(World world, BlockPos pos, int height) {
        return this.isSpaceAt(world, pos, height) && this.ensureDirtsUnderneath(pos, world);
    }

    protected void growLeavesLayerStrict(World world, BlockPos pos, int width) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                IBlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = world.func_180495_p(blockpos = pos.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos)) continue;
                this.func_175903_a(world, blockpos, NibiruBlocks.NIBIRU_LEAVES.func_176203_a(2));
            }
        }
    }

    protected void growLeavesLayer(World world, BlockPos pos, int width) {
        int i = width * width;
        for (int j = -width; j <= width; ++j) {
            for (int k = -width; k <= width; ++k) {
                BlockPos blockpos;
                Block block;
                if (j * j + k * k > i || !(block = world.func_180495_p(blockpos = pos.func_177982_a(j, 0, k)).func_177230_c()).isAir(world.func_180495_p(blockpos), (IBlockAccess)world, blockpos) && !block.isLeaves(world.func_180495_p(blockpos), (IBlockAccess)world, blockpos) || !this.genLeaves) continue;
                this.func_175903_a(world, blockpos, NibiruBlocks.NIBIRU_LEAVES.func_176203_a(2));
            }
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        world.func_180495_p(pos).func_177230_c().onPlantGrow(world.func_180495_p(pos), world, pos, source);
    }
}

