/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.biome.layer.GenLayerNibiru;

public class BiomeProviderNibiru
extends BiomeProvider {
    public static ArrayList<Biome> allowedBiomes = new ArrayList<Biome>(Arrays.asList(MPBiomes.INFECTED_FOREST, MPBiomes.INFECTED_PLAINS, MPBiomes.INFECTED_DEAD_TAIGA, MPBiomes.INFECTED_EXTREME_HILLS, MPBiomes.INFECTED_ICE_PLAINS, MPBiomes.INFECTED_JUNGLE, MPBiomes.INFECTED_SWAMPLAND, MPBiomes.GREEN_VEIN));
    private BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);
    private List<Biome> biomesToSpawn = new ArrayList<Biome>();
    private GenLayer zoomedBiomes;
    private GenLayer unzoomedBiomes;

    protected BiomeProviderNibiru() {
        this.biomesToSpawn.addAll(allowedBiomes);
    }

    public BiomeProviderNibiru(long seed) {
        this();
        GenLayer[] agenlayer = GenLayerNibiru.initializeAllBiomeGenerators(seed);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawn;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome biome) {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)MPPlanets.NIBIRU);
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), biome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)MPPlanets.NIBIRU);
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] arrayOfInts = this.unzoomedBiomes.func_75904_a(x, z, width, height);
        for (int i = 0; i < width * height; ++i) {
            biomes[i] = arrayOfInts[i] >= 0 ? Biome.func_150568_d((int)arrayOfInts[i]) : MPBiomes.INFECTED_PLAINS;
        }
        return biomes;
    }

    public Biome[] func_76933_b(Biome[] oldBiomeList, int x, int z, int width, int height) {
        return this.func_76931_a(oldBiomeList, x, z, width, height, true);
    }

    public Biome[] func_76931_a(Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)MPPlanets.NIBIRU);
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiomegenbase = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiomegenbase, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] ai = this.zoomedBiomes.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = ai[i] >= 0 ? Biome.func_150568_d((int)ai[i]) : MPBiomes.INFECTED_PLAINS;
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int l = z + radius >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        for (int k1 = 0; k1 < i1 * j1; ++k1) {
            Biome biomegenbase = Biome.func_150568_d((int)aint[k1]);
            if (allowed.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random rand) {
        IntCache.func_76446_a();
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.unzoomedBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biomegenbase = Biome.func_150568_d((int)aint[l1]);
            if (!biomes.contains(biomegenbase) || blockpos != null && rand.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

