/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.entity;

import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.util.entity.ISpaceMob;

public class EntityInfectedSquid
extends EntityWaterMob
implements IEntityBreathable,
ISpaceMob {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityInfectedSquid(World world) {
        super(world);
        this.func_70105_a(0.95f, 0.95f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom(this));
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() == MPPotions.INFECTED_SPORE ? false : super.func_70687_e(potion);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186381_af;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70171_ac) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)this.field_70181_x)) * 180.0f / (float)Math.PI - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y = 0.0;
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    public boolean canBreath() {
        return true;
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private EntityInfectedSquid squid;

        public AIMoveRandom(EntityInfectedSquid squid) {
            this.squid = squid;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.squid.func_70654_ax();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.field_70171_ac || !this.squid.hasMovementVector() || this.squid.func_70638_az() != null) {
                float f = this.squid.func_70681_au().nextFloat() * (float)Math.PI * 2.0f;
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }
}

