/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNibiruDoublePlant;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiruTallGrass
extends BlockBushMP
implements IShearable,
IBlockVariants,
IGrowable {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);
    protected static AxisAlignedBB TALL_GRASS_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockNibiruTallGrass(String name) {
        super(Material.field_151585_k);
        this.func_149663_c(name);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.INFECTED_TALL_GRASS)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TALL_GRASS_AABB;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(VARIANT) != BlockType.GREEN_VEIN_TALL_GRASS) {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (RANDOM.nextInt(8) != 0) {
                return ret;
            }
            ret.add(new ItemStack(NibiruItems.INFECTED_WHEAT_SEEDS));
            return ret;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (RANDOM.nextInt(24) != 0) {
            return ret;
        }
        ret.add(new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, 6));
        return ret;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        int meta = this.func_176201_c(state);
        if (meta == 0 || meta == 1) {
            return soil.func_177230_c() == NibiruBlocks.INFECTED_GRASS || soil.func_177230_c() == NibiruBlocks.INFECTED_DIRT;
        }
        return soil.func_177230_c() == NibiruBlocks.GREEN_VEIN_GRASS || soil.func_177230_c() == NibiruBlocks.INFECTED_DIRT;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("tall_grass", "fern", "green_vein");
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockNibiruDoublePlant.BlockType type = BlockNibiruDoublePlant.BlockType.DOUBLE_INFECTED_GRASS;
        if (state.func_177229_b(VARIANT) == BlockType.INFECTED_FERN) {
            type = BlockNibiruDoublePlant.BlockType.DOUBLE_INFECTED_FERN;
        }
        if (state.func_177229_b(VARIANT) == BlockType.GREEN_VEIN_TALL_GRASS) {
            type = BlockNibiruDoublePlant.BlockType.DOUBLE_GREEN_VEIN_GRASS;
        }
        if (NibiruBlocks.NIBIRU_DOUBLE_PLANT.func_176196_c(world, pos)) {
            NibiruBlocks.NIBIRU_DOUBLE_PLANT.placeAt(world, pos, type, 2);
        }
    }

    public static enum BlockType implements IStringSerializable
    {
        INFECTED_TALL_GRASS,
        INFECTED_FERN,
        GREEN_VEIN_TALL_GRASS;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

