/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.items.ItemNibiruFruits;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.EnumParticleTypesMP;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockLeavesMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public class BlockNibiruLeaves
extends BlockLeavesMP
implements IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);
    int[] adjacentTreeBlocks;

    public BlockNibiruLeaves(String name) {
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.INFECTED_OAK_LEAVES)).func_177226_a((IProperty)BlockStateHelper.CHECK_DECAY, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockStateHelper.DECAYABLE, (Comparable)Boolean.valueOf(true)));
        this.func_149663_c(name);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (state.func_177229_b(VARIANT) == BlockType.ALIEN_BERRY_OAK_LEAVES && !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && rand.nextInt(10) == 0) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            MorePlanetsCore.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_BERRY_LEAVES, d0, d1, d2);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)NibiruBlocks.NIBIRU_SAPLING);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, BlockStateHelper.DECAYABLE, BlockStateHelper.CHECK_DECAY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[(meta & 3) % 4])).func_177226_a((IProperty)BlockStateHelper.DECAYABLE, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)BlockStateHelper.CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateHelper.DECAYABLE)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockStateHelper.CHECK_DECAY)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state) & 3);
    }

    public ArrayList<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, ((BlockType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).ordinal()));
        return ret;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("infected_oak", "infected_dead_oak", "infected_jungle", "alien_berry");
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    @Override
    protected void dropFruits(World world, BlockPos pos, IBlockState state, int chance) {
        if (world.field_73012_v.nextInt(chance) == 0) {
            if (state.func_177229_b(VARIANT) == BlockType.INFECTED_OAK_LEAVES || state.func_177229_b(VARIANT) == BlockType.INFECTED_DEAD_OAK_LEAVES) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, ItemNibiruFruits.ItemType.INFECTED_APPLE.ordinal()));
            } else if (state.func_177229_b(VARIANT) == BlockType.ALIEN_BERRY_OAK_LEAVES) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(NibiruItems.NIBIRU_FRUITS, 1, ItemNibiruFruits.ItemType.ALIEN_BERRY.ordinal()));
            }
        }
    }

    public static enum BlockType implements IStringSerializable
    {
        INFECTED_OAK_LEAVES,
        INFECTED_DEAD_OAK_LEAVES,
        INFECTED_JUNGLE_LEAVES,
        ALIEN_BERRY_OAK_LEAVES;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

