/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNibiruLeaves;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenTerrashroom;
import stevekung.mods.moreplanets.util.CompatibilityManagerMP;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiruFlower
extends BlockBushMP
implements IBlockVariants,
IGrowable {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockNibiruFlower(String name) {
        super(Material.field_151585_k);
        this.func_149663_c(name);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.PURE_HURB)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
        }
        if (meta == 4) {
            return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.6, 0.75);
        }
        if (meta == 5) {
            return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.9, 0.75);
        }
        if (meta == 6) {
            return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
        }
        if (meta == 7) {
            return new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
        }
        return new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.8, 0.7);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == 7 && rand.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (world.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.func_175623_d(blockpos1) && this.canBlockStay(world, blockpos1, this.func_176203_a(7))) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (world.func_175623_d(blockpos1) && this.canBlockStay(world, blockpos1, this.func_176203_a(7))) {
                world.func_180501_a(blockpos1, this.func_176203_a(7), 2);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return 2;
        }
        if (meta == 1 || meta == 6) {
            return 4;
        }
        if (meta == 7) {
            return 1;
        }
        return 0;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState blockDown = world.func_180495_p(pos.func_177977_b());
        IBlockState blockUp = world.func_180495_p(pos.func_177984_a());
        int meta = this.func_176201_c(state);
        if (meta == 1) {
            return blockDown.func_177230_c() == NibiruBlocks.GREEN_VEIN_GRASS || blockDown.func_177230_c() == NibiruBlocks.INFECTED_DIRT;
        }
        if (meta == 2) {
            return blockDown.func_177230_c() == NibiruBlocks.INFECTED_SAND;
        }
        if (meta == 6) {
            return blockUp.func_177230_c() == NibiruBlocks.NIBIRU_LEAVES && blockUp.func_177229_b(BlockNibiruLeaves.VARIANT) == BlockNibiruLeaves.BlockType.INFECTED_JUNGLE_LEAVES || blockUp.func_177230_c() == this && blockUp.func_177229_b(VARIANT) == BlockType.VEALIUM_VINE_FLOWER;
        }
        if (meta == 7) {
            boolean lowlight = world.func_175699_k(pos) < 13 && (blockDown.func_177230_c() == NibiruBlocks.NIBIRU_BLOCK || blockDown.func_177230_c() == NibiruBlocks.INFECTED_DIRT || blockDown.func_177230_c() == NibiruBlocks.NIBIRU_ORE);
            return blockDown.func_177230_c() == NibiruBlocks.GREEN_VEIN_GRASS || blockDown.func_177230_c() == NibiruBlocks.TERRASTONE || blockDown.func_177230_c() == NibiruBlocks.PURIFY_GRAVEL || lowlight;
        }
        return blockDown.func_177230_c() == NibiruBlocks.INFECTED_GRASS || blockDown.func_177230_c() == NibiruBlocks.INFECTED_DIRT;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return state.func_177229_b(VARIANT) == BlockType.TERRASHROOM;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.generateBigMushroom(world, pos, state, rand);
    }

    private boolean generateBigMushroom(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos);
        WorldGenTerrashroom worldgenerator = new WorldGenTerrashroom();
        if (worldgenerator.func_180709_b(world, rand, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 3);
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177229_b(VARIANT) == BlockType.TERRAPUFF_HURB && CompatibilityManagerMP.isCTMLoaded ? layer == BlockRenderLayer.CUTOUT : (state.func_177229_b(VARIANT) == BlockType.TERRASHROOM ? layer == BlockRenderLayer.TRANSLUCENT : super.canRenderInLayer(state, layer));
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("pure_hurb", "terrapuff_hurb", "batasia_dandelion", "pyolonia_flower", "philipy_flower", "white_tail", "vealium_vine_flower", "terrashroom");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        PURE_HURB,
        TERRAPUFF_HURB,
        BATASIA_DANDELION,
        PYOLONIA_FLOWER,
        PHILIPY_FLOWER,
        WHITE_TAIL,
        VEALIUM_VINE_FLOWER,
        TERRASHROOM;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

