/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiru
extends BlockBaseMP
implements IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockNibiru(String name) {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.NIBIRU_ROCK)));
        this.func_149663_c(name);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return this.func_176201_c(world.func_180495_p(pos)) == 7;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0 || meta >= 3 && meta <= 6) {
            return 1.5f;
        }
        if (meta == 1 || meta == 2) {
            return 2.0f;
        }
        if (meta == 7) {
            return 5.0f;
        }
        return 4.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.func_176201_c(world.func_180495_p(pos)) == 8 || this.func_176201_c(world.func_180495_p(pos)) == 9) {
            return 40.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_176201_c(world.func_180495_p(pos)) == 7 ? SoundType.field_185852_e : SoundType.field_185851_d;
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_176201_c(state) == 0) {
            return 1;
        }
        return this.func_176201_c(state);
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        switch (meta) {
            case 7: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
            case 8: 
            case 9: {
                return EnumSortCategoryBlock.DUNGEON_BRICK;
            }
        }
        return EnumSortCategoryBlock.BUILDING_BLOCK;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("nibiru_rock", "nibiru_cobblestone", "nibiru_vein_cobblestone", "infected_stone_bricks", "infected_vein_stone_bricks", "infected_cracked_stone_bricks", "infected_chiseled_stone_bricks", "inferumite_block", "nibiru_dungeon_brick", "mossy_nibiru_dungeon_brick");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        NIBIRU_ROCK,
        NIBIRU_COBBLESTONE,
        NIBIRU_VEIN_COBBLESTONE,
        INFECTED_STONE_BRICKS,
        INFECTED_VEIN_STONE_BRICKS,
        INFECTED_CRACKED_STONE_BRICKS,
        INFECTED_CHISELED_STONE_BRICKS,
        INFERUMITE_BLOCK,
        NIBIRU_DUNGEON_BRICK,
        MOSSY_NIBIRU_DUNGEON_BRICK;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

