/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.util.DamageSourceMP;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.helper.BlockEventHelper;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public class BlockInfectedCactus
extends BlockBushMP {
    protected static AxisAlignedBB CACTUS_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    protected static AxisAlignedBB CACTUS_COLLISION_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockInfectedCactus(String name) {
        super(Material.field_151570_A);
        this.func_149663_c(name);
        this.func_149711_c(0.4f);
        this.setSoundType(SoundType.field_185854_g);
        this.func_149675_a(true);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockPos blockpos = pos.func_177984_a();
        if (world.func_175623_d(blockpos)) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)BlockStateHelper.AGE);
                if (j == 15) {
                    world.func_175656_a(blockpos, this.func_176223_P());
                    IBlockState iblockstate = state.func_177226_a((IProperty)BlockStateHelper.AGE, (Comparable)Integer.valueOf(0));
                    world.func_180501_a(pos, iblockstate, 4);
                    iblockstate.func_189546_a(world, blockpos, (Block)this, pos);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CACTUS_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return CACTUS_COLLISION_AABB.func_186670_a(pos);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos, state)) {
            world.func_175655_b(pos, true);
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!world.func_180495_p(pos.func_177972_a(enumfacing)).func_185904_a().func_76220_a()) continue;
            return false;
        }
        if (BlockEventHelper.isLiquidBlock(world, pos)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == NibiruBlocks.INFECTED_SAND || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.func_70097_a(DamageSourceMP.INFECTED_GAS, 1.0f);
        entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_NON_BLOCK;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockStateHelper.AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.AGE});
    }

    @Override
    public String getName() {
        return "infected_cactus";
    }
}

