/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.tileentity;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.util.dimension.IDarkEnergyProvider;

public class TileEntityDarkEnergyGenerator
extends TileBaseUniversalElectricalSource
implements IDisableableMachine,
ISidedInventory,
IConnector,
IInventoryDefaults {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int darkEnergyFuel = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int prevDarkEnergyFuel = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int facing;
    public NonNullList<ItemStack> containingItems = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int renderTicks;
    private boolean initialize = true;

    public TileEntityDarkEnergyGenerator() {
        this.storage.setMaxExtract(2500.0f);
        this.storage.setMaxReceive(2500.0f);
        this.storage.setCapacity(500000.0f);
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (this.initialize) {
            this.renderTicks += this.field_145850_b.field_73012_v.nextInt(100);
            this.initialize = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.receiveEnergyGC(null, this.generateWatts, false);
            this.recharge((ItemStack)this.containingItems.get(0));
            this.recharge((ItemStack)this.containingItems.get(1));
            if (!this.disabled) {
                if (this.ticks % 20 == 0 && this.darkEnergyFuel > 0) {
                    --this.darkEnergyFuel;
                }
                if (!((ItemStack)this.containingItems.get(2)).func_190926_b() && this.darkEnergyFuel <= 0) {
                    this.prevDarkEnergyFuel = this.darkEnergyFuel = 1000;
                    ((ItemStack)this.containingItems.get(2)).func_190918_g(1);
                }
            }
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if ((float)this.getGenerate() > 0.0f) {
                this.ticks += this.field_145850_b.field_73012_v.nextInt(2);
                if (this.ticks % 33 == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), MPSounds.MACHINE_GENERATOR_AMBIENT, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.generateWatts = Math.min(Math.max(this.getGenerate(), 0), 1500);
            } else {
                this.generateWatts = 0;
            }
        }
        this.produce();
    }

    public int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        return this.field_145850_b.field_73011_w instanceof IDarkEnergyProvider ? ((IDarkEnergyProvider)this.field_145850_b.field_73011_w).getDarkEnergyMultiplier(this.field_145850_b, this.field_174879_c) + this.darkEnergyFuel : 100 + this.darkEnergyFuel;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("MaxEnergy"));
        this.setDisabled(0, nbt.func_74767_n("Disabled"));
        this.disableCooldown = nbt.func_74762_e("DisabledCooldown");
        this.facing = nbt.func_74762_e("Facing");
        this.darkEnergyFuel = nbt.func_74762_e("DarkEnergyFuel");
        this.prevDarkEnergyFuel = nbt.func_74762_e("PrevDarkEnergyFuel");
        this.containingItems = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.containingItems);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("MaxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74768_a("DisabledCooldown", this.disableCooldown);
        nbt.func_74757_a("Disabled", this.getDisabled(0));
        nbt.func_74768_a("Facing", this.facing);
        nbt.func_74768_a("DarkEnergyFuel", this.darkEnergyFuel);
        nbt.func_74768_a("PrevDarkEnergyFuel", this.prevDarkEnergyFuel);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.containingItems);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Facing", this.facing);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == -1) {
            NBTTagCompound nbt = pkt.func_148857_g();
            this.facing = nbt.func_74762_e("Facing");
        }
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getFront());
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.dark_energy_generator.name");
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70302_i_() {
        return this.containingItems.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.getItems().set(index, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        return this.func_94041_b(slotID, itemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0 || slotID == 1;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 2) {
            return itemStack.func_77973_b() == DionaItems.DARK_ENERGY_PEARL;
        }
        return (slotID == 0 || slotID == 1) && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.containingItems) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.containingItems;
    }
}

