/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.module.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBasicMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockDiona
extends BlockBasicMP
implements IDetectableResource,
ITerraformableBlock,
IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockDiona(String name) {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.DIONA_SURFACE_ROCK)));
        this.func_149663_c(name);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return this.func_176201_c(world.func_180495_p(pos)) == 9 || this.func_176201_c(world.func_180495_p(pos)) == 10;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0 || meta == 1) {
            return 1.25f;
        }
        if (meta == 2) {
            return 1.5f;
        }
        if (meta == 3) {
            return 2.0f;
        }
        if (meta >= 4 && meta <= 8) {
            return 3.0f;
        }
        if (meta == 9 || meta == 10) {
            return 5.0f;
        }
        return 4.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.func_176201_c(world.func_180495_p(pos)) == 11) {
            return 40.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_176201_c(world.func_180495_p(pos)) == 9 || this.func_176201_c(world.func_180495_p(pos)) == 10 ? SoundType.field_185852_e : SoundType.field_185851_d;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.func_176201_c(state) == 4) {
            return DionaItems.DIONA_ITEM;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_176201_c(state) == 2) {
            return 3;
        }
        if (this.func_176201_c(state) == 4) {
            return 1;
        }
        return this.func_176201_c(state);
    }

    public boolean isValueable(IBlockState state) {
        return this.func_176201_c(state) >= 4 && this.func_176201_c(state) <= 8;
    }

    @Override
    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        if (this.func_176201_c(state) == 4) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return 1 + rand.nextInt(3) * j;
        }
        return this.func_149745_a(rand);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.func_176201_c(state) == 4 ? MathHelper.func_76136_a((Random)new Random(), (int)3, (int)7) : 0;
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        return (meta == 0 || meta == 1) && !world.func_180495_p(pos.func_177984_a()).func_185914_p();
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        switch (meta) {
            default: {
                return EnumSortCategoryBlock.BUILDING_BLOCK;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return EnumSortCategoryBlock.ORE;
            }
            case 9: 
            case 10: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
            case 11: 
        }
        return EnumSortCategoryBlock.DUNGEON_BRICK;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("surface_rock", "sub_surface", "rock", "cobblestone", "setrorium_ore", "illenium_ore", "tin_ore", "copper_ore", "aluminum_ore", "setrorium_block", "illenium_block", "dungeon_brick");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        DIONA_SURFACE_ROCK,
        DIONA_SUB_SURFACE_ROCK,
        DIONA_ROCK,
        DIONA_COBBLESTONE,
        SETRORIUM_ORE,
        ILLENIUM_ORE,
        DIONA_TIN_ORE,
        DIONA_COPPER_ORE,
        DIONA_ALUMINUM_ORE,
        SETRORIUM_BLOCK,
        ILLENIUM_BLOCK,
        DIONA_DUNGEON_BRICK;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

