/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.chalos.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import stevekung.mods.moreplanets.module.planets.chalos.blocks.ChalosBlocks;
import stevekung.mods.moreplanets.module.planets.chalos.items.ChalosItems;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;

public class BlockChalosDoublePlant
extends BlockBushMP
implements IGrowable,
IShearable {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockChalosDoublePlant(String name) {
        super(Material.field_151582_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)BlockType.DOUBLE_CHEESE_TALL_GRASS)).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER));
        this.func_149711_c(0.0f);
        this.setSoundType(SoundType.field_185850_c);
        this.func_149663_c(name);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.func_176196_c(world, pos)) {
            return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        return world.func_180495_p(pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        boolean canPlace = world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_GRASS || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_DIRT || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_FARMLAND;
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && canPlace && world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_177230_c() != this) {
            return true;
        }
        BlockType type = (BlockType)((Object)iblockstate.func_185899_b(world, pos).func_177229_b(VARIANT));
        return type == BlockType.DOUBLE_CHEESE_TALL_GRASS;
    }

    @Override
    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            BlockChalosDoublePlant block1;
            boolean flag = state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER;
            BlockPos blockpos = flag ? pos : pos.func_177984_a();
            BlockPos blockpos1 = flag ? pos.func_177977_b() : pos;
            BlockChalosDoublePlant block = flag ? this : world.func_180495_p(blockpos).func_177230_c();
            BlockChalosDoublePlant blockChalosDoublePlant = block1 = flag ? world.func_180495_p(blockpos1).func_177230_c() : this;
            if (!flag) {
                this.func_176226_b(world, pos, state, 0);
            }
            if (block == this) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (block1 == this) {
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        boolean canPlace;
        boolean bl = canPlace = world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_GRASS || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_DIRT || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ChalosBlocks.CHEESE_FARMLAND;
        if (state.func_177230_c() != this) {
            return canPlace;
        }
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = world.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && canPlace;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return null;
        }
        BlockType type = (BlockType)((Object)state.func_177229_b(VARIANT));
        return type == BlockType.DOUBLE_CHEESE_TALL_GRASS ? (rand.nextInt(8) == 0 ? ChalosItems.CHEESE_SPORE_SEED : null) : Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) != BlockDoublePlant.EnumBlockHalf.UPPER && state.func_177229_b(VARIANT) != BlockType.DOUBLE_CHEESE_TALL_GRASS ? ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal() : 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    IBlockState iblockstate = world.func_180495_p(pos.func_177977_b());
                    BlockType type = (BlockType)((Object)iblockstate.func_177229_b(VARIANT));
                    if (type != BlockType.DOUBLE_CHEESE_TALL_GRASS) {
                        world.func_175655_b(pos.func_177977_b(), true);
                    } else if (world.field_72995_K) {
                        world.func_175698_g(pos.func_177977_b());
                    } else if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
                        this.onHarvest(world, pos, iblockstate, player);
                        world.func_175698_g(pos.func_177977_b());
                    } else {
                        world.func_175655_b(pos.func_177977_b(), true);
                    }
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.getType((IBlockAccess)world, pos, state).ordinal());
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        BlockType type = this.getType((IBlockAccess)world, pos, state);
        return type != BlockType.DOUBLE_CHEESE_TALL_GRASS;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, this.getType((IBlockAccess)world, pos, state).ordinal()));
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER) : this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER).func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta & 7]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER && (iblockstate = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            state = state.func_177226_a(VARIANT, iblockstate.func_177229_b(VARIANT));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER ? 8 : ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoublePlant.field_176492_b, VARIANT});
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BlockType type = (BlockType)((Object)state.func_177229_b(VARIANT));
        return state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER && type == BlockType.DOUBLE_CHEESE_TALL_GRASS;
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BlockType type = (BlockType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT));
        if (type == BlockType.DOUBLE_CHEESE_TALL_GRASS) {
            ret.add(new ItemStack((Block)ChalosBlocks.CHEESE_TALL_GRASS, 2));
        }
        return ret;
    }

    private BlockType getType(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            state = state.func_185899_b(world, pos);
            return (BlockType)((Object)state.func_177229_b(VARIANT));
        }
        return BlockType.DOUBLE_CHEESE_TALL_GRASS;
    }

    public void placeAt(World world, BlockPos lowerPos, BlockType variant, int flags) {
        world.func_180501_a(lowerPos, this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER).func_177226_a(VARIANT, (Comparable)((Object)variant)), flags);
        world.func_180501_a(lowerPos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), flags);
    }

    private boolean onHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockType type = (BlockType)((Object)state.func_177229_b(VARIANT));
        if (type != BlockType.DOUBLE_CHEESE_TALL_GRASS) {
            return false;
        }
        player.func_71029_a(StatList.func_188055_a((Block)this));
        return true;
    }

    public static enum BlockType implements IStringSerializable
    {
        DOUBLE_CHEESE_TALL_GRASS;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

