/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.moons.koentus.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.entity.EntityAntiGravFallingBlock;
import stevekung.mods.moreplanets.module.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBasicMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockKoentus
extends BlockBasicMP
implements IDetectableResource,
ITerraformableBlock,
IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockKoentus(String name) {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.KOENTUS_SURFACE_ROCK)));
        this.func_149663_c(name);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_FRAGMENT_BLOCK || state.func_177229_b(VARIANT) == BlockType.GOLDENITE_CRYSTAL_BLOCK;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0 || meta == 1) {
            return 1.25f;
        }
        if (meta == 2) {
            return 1.5f;
        }
        if (meta == 3) {
            return 2.0f;
        }
        if (meta >= 4 && meta <= 9) {
            return 3.0f;
        }
        if (meta == 10 || meta == 11) {
            return 5.0f;
        }
        return 4.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.func_176201_c(world.func_180495_p(pos)) == 12) {
            return 40.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_FRAGMENT_BLOCK || state.func_177229_b(VARIANT) == BlockType.GOLDENITE_CRYSTAL_BLOCK ? SoundType.field_185852_e : SoundType.field_185851_d;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.func_176201_c(state) == 4) {
            return DionaItems.DIONA_ITEM;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_176201_c(state) == 2) {
            return 3;
        }
        return this.func_176201_c(state);
    }

    public boolean isValueable(IBlockState state) {
        return this.func_176201_c(state) >= 4 && this.func_176201_c(state) <= 9;
    }

    @Override
    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        if (this.func_176201_c(state) == 4) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return 1 + rand.nextInt(3) * j;
        }
        return this.func_149745_a(rand);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.func_176201_c(state) == 4 ? MathHelper.func_76136_a((Random)new Random(), (int)3, (int)7) : 0;
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        return (meta == 0 || meta == 1) && !world.func_180495_p(pos.func_177984_a()).func_185914_p();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_ORE || state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_FRAGMENT_BLOCK) {
            world.func_175684_a(pos, (Block)this, 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_ORE || state.func_177229_b(VARIANT) == BlockType.ANTI_GRAVITY_FRAGMENT_BLOCK) {
            world.func_175684_a(pos, (Block)this, 2);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!(world.field_72995_K || state.func_177229_b(VARIANT) != BlockType.ANTI_GRAVITY_ORE && state.func_177229_b(VARIANT) != BlockType.ANTI_GRAVITY_FRAGMENT_BLOCK)) {
            this.checkFallable(world, pos);
        }
    }

    private void checkFallable(World world, BlockPos pos) {
        if ((world.func_175623_d(pos.func_177984_a()) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177984_a()))) && pos.func_177956_o() < 256) {
            if (!BlockFalling.field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    EntityAntiGravFallingBlock block = new EntityAntiGravFallingBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    world.func_72838_d((Entity)block);
                }
            } else {
                IBlockState state = world.func_180495_p(pos);
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177984_a();
                while ((world.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177984_a();
                }
                if (blockpos.func_177956_o() < 256) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        switch (meta) {
            default: {
                return EnumSortCategoryBlock.BUILDING_BLOCK;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return EnumSortCategoryBlock.ORE;
            }
            case 10: 
            case 11: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
            case 12: 
        }
        return EnumSortCategoryBlock.DUNGEON_BRICK;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("surface_rock", "sub_surface", "rock", "cobblestone", "anti_gravity_ore", "goldenite_crystal_ore", "tin_ore", "copper_ore", "aluminum_ore", "iron_ore", "anti_grav_block", "goldenite_block", "dungeon_brick");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        KOENTUS_SURFACE_ROCK,
        KOENTUS_SUB_SURFACE_ROCK,
        KOENTUS_ROCK,
        KOENTUS_COBBLESTONE,
        ANTI_GRAVITY_ORE,
        GOLDENITE_CRYSTAL_ORE,
        KOENTUS_TIN_ORE,
        KOENTUS_COPPER_ORE,
        KOENTUS_ALUMINUM_ORE,
        KOENTUS_IRON_ORE,
        ANTI_GRAVITY_FRAGMENT_BLOCK,
        GOLDENITE_CRYSTAL_BLOCK,
        KOENTUS_DUNGEON_BRICK;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

