/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.integration.waila;

import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.blocks.BlockDummy;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.integration.waila.HUDHandlerFurnaceMP;
import stevekung.mods.moreplanets.integration.waila.WailaUtil;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityDarkEnergyCore;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityDarkEnergyGenerator;
import stevekung.mods.moreplanets.module.planets.nibiru.tileentity.TileEntityNuclearWasteGenerator;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyStorageCluster;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.moreplanets.tileentity.TileEntityNuclearWasteStorageCluster;
import stevekung.mods.moreplanets.tileentity.TileEntityRocketCrusher;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.tileentity.TileEntitySpaceWarpPadFull;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.blocks.IBlockDescription;
import stevekung.mods.moreplanets.util.helper.CommonRegisterHelper;

@WailaPlugin
public class WailaTileEntityProviderMP
implements IWailaDataProvider,
IWailaPlugin {
    public WailaTileEntityProviderMP() {
        WailaUtil.dataProvider = this;
    }

    public void register(IWailaRegistrar register) {
        MPLog.info("Waila Integration initialized");
        WailaUtil.register = register;
        HUDHandlerFurnaceMP.register(register);
        WailaUtil.register(TileEntityDarkEnergyReceiver.class, true, true, false, false, false);
        WailaUtil.register(TileEntityDarkEnergyCore.class, true, true, false, false, false);
        WailaUtil.register(TileEntitySpaceWarpPadFull.class, true, true, false, false, false);
        WailaUtil.register(TileEntityRocketCrusher.class, true, true, false, false, false);
        WailaUtil.register(TileEntityDarkEnergyGenerator.class, true, true, false, false, false);
        WailaUtil.register(TileEntityDarkEnergyStorageCluster.class, true, true, false, false, false);
        WailaUtil.register(TileEntityNuclearWasteStorageCluster.class, true, true, false, false, false);
        WailaUtil.register(TileEntityBlackHoleStorage.class, true, true, false, false, false);
        WailaUtil.register(TileEntityShieldGenerator.class, true, true, false, false, false);
        WailaUtil.register(TileEntityNuclearWasteGenerator.class, true, true, false, false, false);
        WailaUtil.register(IBlockDescription.class, false, false, true, false, false);
        WailaUtil.register(MPBlocks.DUMMY_BLOCK.getClass(), true, true, true, false, false);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int scale;
        int transform;
        TileEntity tile = accessor.getTileEntity();
        Block block = accessor.getBlock();
        IBlockState state = accessor.getBlockState();
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.func_74764_b("EnergyF") && (block != MPBlocks.DUMMY_BLOCK || state.func_177229_b(BlockDummy.VARIANT) != BlockDummy.BlockType.NUCLEAR_WASTE_TANK_MIDDLE && state.func_177229_b(BlockDummy.VARIANT) != BlockDummy.BlockType.NUCLEAR_WASTE_TANK_TOP)) {
            tooltip.add(TextFormatting.GREEN + GCCoreUtil.translate((String)"gui.message.energy") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("EnergyF")));
        }
        if (block == MPBlocks.DUMMY_BLOCK) {
            BlockDummy.BlockType type = (BlockDummy.BlockType)((Object)state.func_177229_b(BlockDummy.VARIANT));
            if (type == BlockDummy.BlockType.DARK_ENERGY_SOLAR1 || type == BlockDummy.BlockType.DARK_ENERGY_SOLAR2 || type == BlockDummy.BlockType.DARK_ENERGY_SOLAR3 || type == BlockDummy.BlockType.DARK_ENERGY_SOLAR4) {
                int process = nbt.func_74762_e("ActivatedTick") * 100 / 12000;
                int destruct = nbt.func_74762_e("FailedTick");
                if (destruct > 0) {
                    destruct = 600 - destruct;
                    tooltip.add(TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.status.destruct.name") + ": " + CommonRegisterHelper.ticksToElapsedTime(destruct));
                } else {
                    tooltip.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
                }
                if (process > 0 && process < 100) {
                    tooltip.add("Process: " + process + "%");
                }
            }
            if (type == BlockDummy.BlockType.WARP_PAD && tile instanceof TileEntityDummy) {
                TileEntityDummy dummy = (TileEntityDummy)tile;
                TileEntitySpaceWarpPadFull warp = (TileEntitySpaceWarpPadFull)accessor.getWorld().func_175625_s(dummy.mainBlockPosition);
                String dimension = GCCoreUtil.translate((String)"gui.status.unknown.name");
                String name = GCCoreUtil.translate((String)"gui.status.unknown.name");
                String dest = GCCoreUtil.translate((String)"gui.status.unknown.name");
                if (warp.hasWarpCore() && ((ItemStack)warp.containingItems.get(1)).func_77942_o()) {
                    NBTTagCompound compound = ((ItemStack)warp.containingItems.get(1)).func_77978_p();
                    dimension = String.valueOf(compound.func_74762_e("DimensionID"));
                    name = WorldUtil.getProviderForDimensionClient((int)compound.func_74762_e("DimensionID")).func_186058_p().func_186065_b();
                    dest = compound.func_74762_e("X") + " " + compound.func_74762_e("Y") + " " + compound.func_74762_e("Z");
                }
                tooltip.add(GCCoreUtil.translate((String)"gui.status.dimension.name") + ": " + dimension + " ");
                tooltip.add(GCCoreUtil.translate((String)"gui.status.name.name") + ": " + name);
                tooltip.add(GCCoreUtil.translate((String)"gui.status.destination.name") + ": " + dest);
            }
            if (type == BlockDummy.BlockType.SHIELD_GENERATOR_TOP) {
                int chargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
                tooltip.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
                tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_damage.name") + ": " + nbt.func_74762_e("ShieldDamage"));
                tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_size.name") + ": " + nbt.func_74762_e("MaxShieldSize"));
                tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_capacity.name") + ": " + nbt.func_74762_e("ShieldCapacity") + "/" + nbt.func_74762_e("MaxShieldCapacity"));
                if (chargeCooldown > 0) {
                    tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + chargeCooldown / 20);
                }
            }
        }
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            int process = nbt.func_74762_e("ActivatedTick") * 100 / 12000;
            int destruct = nbt.func_74762_e("FailedTick");
            if (destruct > 0) {
                destruct = 600 - destruct;
                tooltip.add(TextFormatting.DARK_RED + GCCoreUtil.translate((String)"gui.status.destruct.name") + ": " + CommonRegisterHelper.ticksToElapsedTime(destruct));
            } else {
                tooltip.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            }
            if (process > 0 && process < 100) {
                tooltip.add(GCCoreUtil.translate((String)"gui.status.process.name") + ": " + process + "%");
            }
        }
        if (tile instanceof TileEntityDarkEnergyCore && (transform = nbt.func_74762_e("ProduceTime")) > 0) {
            tooltip.add(GCCoreUtil.translate((String)"gui.status.transform_time.name") + ": " + CommonRegisterHelper.ticksToElapsedTime(transform));
        }
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            int generateWatts = nbt.func_74762_e("GenerateWatts");
            int fuel = nbt.func_74762_e("DarkEnergyFuel");
            tooltip.add(GCCoreUtil.translate((String)"gui.message.generating.name") + ": " + (generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)generateWatts) + "/t" : GCCoreUtil.translate((String)"gui.status.not_generating.name")));
            tooltip.add(GCCoreUtil.translate((String)"gui.status.dark_energy_fuel.name") + ": " + (fuel > 0 ? String.valueOf(fuel * 100 / 1000) + "%" : TextFormatting.GOLD + GCCoreUtil.translate((String)"gui.status.empty.name")));
        }
        if (tile instanceof TileEntitySpaceWarpPadFull) {
            TileEntitySpaceWarpPadFull warp = (TileEntitySpaceWarpPadFull)tile;
            String dimension = GCCoreUtil.translate((String)"gui.status.unknown.name");
            String name = GCCoreUtil.translate((String)"gui.status.unknown.name");
            String dest = GCCoreUtil.translate((String)"gui.status.unknown.name");
            if (warp.hasWarpCore() && ((ItemStack)warp.containingItems.get(1)).func_77942_o()) {
                NBTTagCompound compound = ((ItemStack)warp.containingItems.get(1)).func_77978_p();
                dimension = String.valueOf(compound.func_74762_e("DimensionID"));
                name = WorldUtil.getProviderForDimensionClient((int)compound.func_74762_e("DimensionID")).func_186058_p().func_186065_b();
                dest = compound.func_74762_e("X") + " " + compound.func_74762_e("Y") + " " + compound.func_74762_e("Z");
            }
            tooltip.add(GCCoreUtil.translate((String)"gui.status.dimension.name") + ": " + dimension + " ");
            tooltip.add(GCCoreUtil.translate((String)"gui.status.name.name") + ": " + name);
            tooltip.add(GCCoreUtil.translate((String)"gui.status.destination.name") + ": " + dest);
        }
        if (tile instanceof TileEntityDarkEnergyStorageCluster || tile instanceof TileEntityNuclearWasteStorageCluster || tile instanceof TileEntityNuclearWasteGenerator) {
            tooltip.add(TextFormatting.GREEN + GCCoreUtil.translate((String)"gui.message.max_energy") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("MaxEnergy")));
            tooltip.add(GCCoreUtil.translate((String)"gui.max_output.desc") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)nbt.func_74760_g("MaxOutput")) + "/t");
            if (nbt.func_74764_b("Status")) {
                tooltip.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            }
        }
        if (tile instanceof TileEntityRocketCrusher && (scale = (int)((double)nbt.func_74762_e("ProcessTicks") / (double)nbt.func_74762_e("ProcessTime") * 100.0)) > 0) {
            tooltip.add(GCCoreUtil.translate((String)"gui.electric_compressor.desc.0") + ": " + scale + "%");
        }
        if (tile instanceof TileEntityBlackHoleStorage) {
            String owner = GCCoreUtil.translate((String)"gui.status.unknown.name");
            String collectMode = nbt.func_74779_i("CollectMode").equals("item") ? GCCoreUtil.translate((String)"gui.status.collect_item.name") : (nbt.func_74779_i("CollectMode").equals("item_and_xp") ? GCCoreUtil.translate((String)"gui.status.collect_item_and_xp.name") : GCCoreUtil.translate((String)"gui.status.collect_xp.name"));
            try {
                owner = accessor.getWorld().func_152378_a(UUID.fromString(nbt.func_74779_i("OwnerUUID"))).func_70005_c_();
            }
            catch (Exception e) {
                owner = "";
            }
            int xp = nbt.func_150297_b("XpFluid", 10) ? nbt.func_74775_l("XpFluid").func_74762_e("Amount") : 0;
            tooltip.add(GCCoreUtil.translate((String)"gui.status.owner.name") + ": " + owner);
            tooltip.add(GCCoreUtil.translate((String)"gui.status.mode.name") + ": " + collectMode);
            tooltip.add(GCCoreUtil.translate((String)"desc.bhs_xp.name") + ": " + xp + "/" + 1000000);
        }
        if (tile instanceof TileEntityShieldGenerator) {
            int chargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
            tooltip.add(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + nbt.func_74779_i("Status"));
            tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_damage.name") + ": " + nbt.func_74762_e("ShieldDamage"));
            tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_size.name") + ": " + nbt.func_74762_e("MaxShieldSize"));
            tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_capacity.name") + ": " + nbt.func_74762_e("ShieldCapacity") + "/" + nbt.func_74762_e("MaxShieldCapacity"));
            if (chargeCooldown > 0) {
                tooltip.add(GCCoreUtil.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + chargeCooldown / 20);
            }
        }
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        Block block = accessor.getBlock();
        if (ConfigManagerMP.enableDescriptionInWaila) {
            if (block instanceof IBlockDescription) {
                IBlockDescription desc = (IBlockDescription)block;
                if (CommonRegisterHelper.isShiftKeyDown()) {
                    desc.getDescription().addDescription(itemStack, tooltip);
                } else {
                    tooltip.add(GCCoreUtil.translate((String)"desc.shift_info.name"));
                }
            }
            if (block == MPBlocks.DUMMY_BLOCK) {
                TileEntityDummy dummy = (TileEntityDummy)tile;
                if (accessor.getWorld().func_180495_p(dummy.mainBlockPosition).func_177230_c() instanceof IBlockDescription) {
                    IBlockDescription desc = (IBlockDescription)accessor.getWorld().func_180495_p(dummy.mainBlockPosition).func_177230_c();
                    if (CommonRegisterHelper.isShiftKeyDown()) {
                        desc.getDescription().addDescription(itemStack, tooltip);
                    } else {
                        tooltip.add(GCCoreUtil.translate((String)"desc.shift_info.name"));
                    }
                }
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound nbt, World world, BlockPos pos) {
        TileBaseUniversalElectricalSource energy;
        TileBaseUniversalElectricalSource generator;
        if (tile instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)tile;
            if (world.func_175625_s(dummy.mainBlockPosition) instanceof TileEntityDarkEnergyReceiver) {
                TileEntityDarkEnergyReceiver receiver = (TileEntityDarkEnergyReceiver)world.func_175625_s(dummy.mainBlockPosition);
                nbt.func_74778_a("Status", receiver.getGuiStatusWaila());
                return receiver.func_189515_b(nbt);
            }
            if (world.func_175625_s(dummy.mainBlockPosition) instanceof TileEntityShieldGenerator) {
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)world.func_175625_s(dummy.mainBlockPosition);
                nbt.func_74778_a("Status", shield.getStatus());
                return shield.func_189515_b(nbt);
            }
        }
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver receiver = (TileEntityDarkEnergyReceiver)tile;
            nbt.func_74778_a("Status", receiver.getGuiStatusWaila());
            return receiver.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            generator = (TileEntityDarkEnergyGenerator)tile;
            nbt.func_74768_a("GenerateWatts", generator.generateWatts);
            return generator.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityDarkEnergyStorageCluster) {
            energy = (TileEntityDarkEnergyStorageCluster)tile;
            nbt.func_74776_a("MaxEnergy", energy.getMaxEnergyStoredGC());
            nbt.func_74776_a("MaxOutput", energy.storage.getMaxExtract());
            return energy.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityNuclearWasteStorageCluster) {
            energy = (TileEntityNuclearWasteStorageCluster)tile;
            nbt.func_74776_a("MaxEnergy", energy.getMaxEnergyStoredGC());
            nbt.func_74776_a("MaxOutput", energy.storage.getMaxExtract());
            return energy.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityRocketCrusher) {
            TileEntityRocketCrusher crusher = (TileEntityRocketCrusher)tile;
            nbt.func_74768_a("ProcessTime", crusher.processTimeRequired);
            return crusher.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityShieldGenerator) {
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            nbt.func_74778_a("Status", shield.getStatus());
            return shield.func_189515_b(nbt);
        }
        if (tile instanceof TileEntityNuclearWasteGenerator) {
            generator = (TileEntityNuclearWasteGenerator)tile;
            nbt.func_74778_a("Status", generator.getStatus());
            nbt.func_74776_a("MaxEnergy", generator.getMaxEnergyStoredGC());
            nbt.func_74776_a("MaxOutput", generator.storage.getMaxExtract());
            return generator.func_189515_b(nbt);
        }
        return tile.func_189515_b(nbt);
    }
}

