/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.module.planets.diona.entity.EntityZeliusZombie;
import stevekung.mods.moreplanets.module.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityInfectedZombie;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityShlime;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.util.CompatibilityManagerMP;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.TeleportUtil;
import stevekung.mods.moreplanets.util.helper.EntityEffectHelper;
import stevekung.mods.moreplanets.world.IMeteorType;

public class EntityEventHandler {
    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.getEntity() instanceof EntityInfectedZombie) {
            event.setCustomSummonedAid((EntityZombie)new EntityInfectedZombie(event.getWorld()));
            if ((double)((EntityLivingBase)event.getEntity()).func_70681_au().nextFloat() < ((EntityInfectedZombie)event.getEntity()).func_110148_a(((EntityInfectedZombie)event.getEntity()).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity() instanceof EntityZeliusZombie) {
            event.setCustomSummonedAid((EntityZombie)new EntityZeliusZombie(event.getWorld()));
            if ((double)((EntityLivingBase)event.getEntity()).func_70681_au().nextFloat() < ((EntityZeliusZombie)event.getEntity()).func_110148_a(((EntityZeliusZombie)event.getEntity()).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        int id = GCCoreUtil.getDimensionID((World)living.field_70170_p);
        PacketSimpleMP.sendToAllAround(new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_REMOVE_ENTITY_ID, id, String.valueOf(living.func_145782_y())), living.field_70170_p, id, living.func_180425_c(), 64.0);
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase living;
        if (!CompatibilityManagerMP.isBaubleLoaded && (living = event.getEntityLiving()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (player.field_71071_by.func_70431_c(new ItemStack(MPItems.GRAVITY_AMULET))) {
                event.setCanceled(true);
            } else {
                event.setCanceled(false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        if (living.field_70128_L) {
            int id = GCCoreUtil.getDimensionID((World)living.field_70170_p);
            PacketSimpleMP.sendToAllAround(new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_REMOVE_ENTITY_ID, id, String.valueOf(living.func_145782_y())), living.field_70170_p, id, living.func_180425_c(), 64.0);
        }
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (!(!ConfigManagerMP.enableStartedPlanet || WorldTickEventHandler.startedDimensionData.startedDimension || ConfigManagerMP.startedPlanet.equals("planet.") || ConfigManagerMP.startedPlanet.equals("moon.") || ConfigManagerMP.startedPlanet.equals("satellite."))) {
                MPLog.debug("Start teleporting player to dimension {}", ConfigManagerMP.startedPlanet);
                TeleportUtil.startNewDimension(player);
                WorldTickEventHandler.startedDimensionData.startedDimension = true;
                WorldTickEventHandler.startedDimensionData.planetToBack = ConfigManagerMP.startedPlanet;
                WorldTickEventHandler.startedDimensionData.func_76186_a(true);
            }
            if (player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || this.isInOxygen(world, (EntityPlayer)player)) {
                player.func_184589_d(MPPotions.INFECTED_SPORE);
            }
            if (player.func_70644_a(MPPotions.DARK_ENERGY_PROTECTION)) {
                player.func_184589_d(MPPotions.DARK_ENERGY);
            }
            if (world.field_73011_w instanceof WorldProviderNibiru) {
                if (world.func_175727_C(player.func_180425_c()) && !this.isGodPlayer((EntityPlayer)player) && !player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) && world.func_180494_b(player.func_180425_c()) != MPBiomes.GREEN_VEIN) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
                }
                if (!(player.field_70173_aa % 128 != 0 || this.isGodPlayer((EntityPlayer)player) || this.isInOxygen(world, (EntityPlayer)player) || player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || world.func_180494_b(player.func_180425_c()) == MPBiomes.GREEN_VEIN)) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
                }
            }
            if (world.field_73011_w instanceof IMeteorType) {
                // empty if block
            }
        }
        if (world.field_73011_w instanceof WorldProviderNibiru && !(living instanceof EntityPlayer) && !EntityEffectHelper.isGalacticraftMob((Entity)living) && !(living instanceof EntityJuicer)) {
            if (living.field_70173_aa % 128 == 0 && world.func_180494_b(living.func_180425_c()) != MPBiomes.GREEN_VEIN) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
            }
            if (world.func_175727_C(living.func_180425_c()) && world.func_180494_b(living.func_180425_c()) != MPBiomes.GREEN_VEIN) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
            }
        }
    }

    @SubscribeEvent
    public void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)(itemStack.func_77952_i() & 0xF));
            if (entity instanceof EntityShlime) {
                EntityShlime shlime = (EntityShlime)entity;
                if (!shlime.getSheared() && shlime.getFleeceColor() != color) {
                    shlime.setFleeceColor(color);
                    if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                        itemStack.func_190918_g(1);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    public void spawnMeteor(World world, EntityPlayerMP player, IMeteorType meteor) {
        EntityMeteor meteorEntity = null;
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((IMeteorType)world.field_73011_w).getMeteorSpawnFrequency() > 0.0 && meteor.getMeteorType() != null) {
            EntityPlayer closestPlayer;
            int f = (int)(((IMeteorType)world.field_73011_w).getMeteorSpawnFrequency() * 750.0);
            int r = ((WorldServer)world).func_73046_m().func_184103_al().func_72395_o();
            int x = world.field_73012_v.nextInt(20) + 160;
            int z = world.field_73012_v.nextInt(20) - 10;
            double motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            double motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            int px = MathHelper.func_76128_c((double)player.field_70165_t);
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                if ((x + px >> 4) - (px >> 4) >= r) {
                    x = ((px >> 4) + r << 4) - 1 - px;
                }
                switch (meteor.getMeteorType()) {
                    case ANTAROS: {
                        meteorEntity = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                    }
                }
                if (!world.field_72995_K) {
                    world.func_72838_d(meteorEntity);
                    MPLog.debug("Spawn {} at {} {} {}", meteor.getClass().getSimpleName(), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                switch (meteor.getMeteorType()) {
                    case ANTAROS: {
                        meteorEntity = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                    }
                }
                if (!world.field_72995_K) {
                    world.func_72838_d(meteorEntity);
                    MPLog.debug("Spawn {} at {} {} {}", meteor.getClass().getSimpleName(), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
            }
        }
    }

    private boolean isInOxygen(World world, EntityPlayer player) {
        return OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
    }

    private boolean isGodPlayer(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || player.func_175149_v();
    }
}

