/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.renderer.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import stevekung.mods.moreplanets.client.model.ModelShieldGenerator;
import stevekung.mods.moreplanets.client.renderer.OBJLoaderMP;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;

public class TileEntityShieldGeneratorRenderer
extends TileEntitySpecialRenderer<TileEntityShieldGenerator> {
    private IBakedModel shield;
    private ModelShieldGenerator model = new ModelShieldGenerator();
    private static final ResourceLocation texture = new ResourceLocation("moreplanets:textures/model/shield_generator.png");
    public static final TileEntityShieldGeneratorRenderer INSTANCE = new TileEntityShieldGeneratorRenderer();

    private void updateModels() {
        if (this.shield == null) {
            try {
                this.shield = OBJLoaderMP.getModelFromOBJ(new ResourceLocation("moreplanets:shield.obj"), (List<String>)ImmutableList.of((Object)"Shield"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void render(TileEntityShieldGenerator tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        float renderPartialTicks = (float)tile.renderTicks + partialTicks;
        float lightTime = (MathHelper.func_76126_a((float)(renderPartialTicks / 16.0f)) + 1.0f) / 2.0f + 0.15f;
        this.updateModels();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)tile.facing, (float)0.0f, (float)1.0f, (float)0.0f);
        if (tile.getBubbleVisible()) {
            GlStateManager.func_179094_E();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179132_a((boolean)false);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179152_a((float)tile.getBubbleSize(), (float)tile.getBubbleSize(), (float)tile.getBubbleSize());
            int capacity = tile.shieldCapacity * 171 / tile.maxShieldCapacity;
            int color = ColorUtil.to32BitColor((int)(capacity + 84), (int)255, (int)255, (int)255);
            ClientUtil.drawBakedModelColored((IBakedModel)this.shield, (int)color);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179124_c((float)lightTime, (float)lightTime, (float)lightTime);
        this.func_147499_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow1.png"));
        this.model.renderBase();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(tile.hasEnoughEnergyToRun && !tile.disabled ? partialTicks + (float)tile.solarRotate : (float)tile.solarRotate), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow1.png"));
        this.model.renderRod();
        GlStateManager.func_179121_F();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow2.png"));
        this.model.renderBase();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(tile.hasEnoughEnergyToRun && !tile.disabled ? partialTicks + (float)tile.solarRotate : (float)tile.solarRotate), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow2.png"));
        this.model.renderRod();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        this.func_147499_a(texture);
        this.model.renderBase();
        GlStateManager.func_179114_b((float)(tile.hasEnoughEnergyToRun && !tile.disabled ? partialTicks + (float)tile.solarRotate : (float)tile.solarRotate), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.renderRod();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render() {
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        float renderPartialTicks = ClientEventHandler.itemRendererTicks;
        float lightTime = (MathHelper.func_76126_a((float)(renderPartialTicks / 16.0f)) + 1.0f) / 2.0f + 0.15f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)0.5f, (float)1.5f, (float)0.5f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179124_c((float)lightTime, (float)lightTime, (float)lightTime);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow1.png"));
        this.model.renderBase();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow1.png"));
        this.model.renderRod();
        GlStateManager.func_179121_F();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow2.png"));
        this.model.renderBase();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("moreplanets:textures/model/shield_generator_glow2.png"));
        this.model.renderRod();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        this.model.renderBase();
        this.model.renderRod();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }
}

