/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import com.google.common.base.Predicate;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyStorageCluster;
import stevekung.mods.moreplanets.tileentity.TileEntityNuclearWasteStorageCluster;
import stevekung.mods.moreplanets.util.ItemDescription;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockTileMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockDescription;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;
import stevekung.mods.moreplanets.util.blocks.ISortableBlock;
import stevekung.mods.moreplanets.util.helper.ItemDescriptionHelper;

public class BlockTieredEnergyStorage
extends BlockTileMP
implements IBlockDescription,
ISortableBlock,
IBlockVariants {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variants", BlockType.class);
    public static PropertyInteger VALUE = PropertyInteger.func_177719_a((String)"value", (int)0, (int)33);
    public static IMachineSidesProperties MACHINESIDES_RENDERTYPE = IMachineSidesProperties.TWOFACES_HORIZ;
    public static PropertyEnum<IMachineSidesProperties.MachineSidesModel> SIDES = BlockTieredEnergyStorage.MACHINESIDES_RENDERTYPE.asProperty;

    public BlockTieredEnergyStorage(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)BlockType.DARK_ENERGY_STORAGE_MODULE)).func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int meta = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        if (meta >= 4) {
            world.func_180501_a(pos, this.func_176203_a(4 + change), 3);
        } else if (meta >= 0) {
            world.func_180501_a(pos, this.func_176203_a(change), 3);
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("EnergyStored")) {
            TileBaseUniversalElectricalSource electric;
            if (world.func_175625_s(pos) instanceof TileEntityDarkEnergyStorageCluster) {
                electric = (TileEntityDarkEnergyStorageCluster)world.func_175625_s(pos);
                electric.storage.setEnergyStored(itemStack.func_77978_p().func_74760_g("EnergyStored"));
            }
            if (world.func_175625_s(pos) instanceof TileEntityNuclearWasteStorageCluster) {
                electric = (TileEntityNuclearWasteStorageCluster)world.func_175625_s(pos);
                ((TileEntityNuclearWasteStorageCluster)electric).storage.setEnergyStored(itemStack.func_77978_p().func_74760_g("EnergyStored"));
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        TileBaseUniversalElectricalSource electric;
        ItemStack machine;
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityDarkEnergyStorageCluster) {
            machine = new ItemStack((Block)this, 1, 0);
            electric = (TileEntityDarkEnergyStorageCluster)tile;
            if (electric.getEnergyStoredGC() > 0.0f) {
                machine.func_77982_d(new NBTTagCompound());
                machine.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
        if (tile instanceof TileEntityNuclearWasteStorageCluster) {
            machine = new ItemStack((Block)this, 1, 4);
            electric = (TileEntityNuclearWasteStorageCluster)tile;
            if (electric.getEnergyStoredGC() > 0.0f) {
                machine.func_77982_d(new NBTTagCompound());
                machine.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock((IBlockState)state, (World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)FACING)));
        return true;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)MorePlanetsCore.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 0 && meta <= 3) {
            return new TileEntityDarkEnergyStorageCluster();
        }
        return new TileEntityNuclearWasteStorageCluster();
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 4));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 0xC;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = this.func_176201_c(state);
        if (meta >= 0 && meta <= 3) {
            return new ItemStack((Block)this, 1, 0);
        }
        return new ItemStack((Block)this, 1, 4);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        BlockType type = BlockType.valuesCached()[(int)Math.floor(meta / 4)];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal() * 4;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT, VALUE, SIDES});
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE_BLOCK;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        state = IMachineSides.addPropertyForTile((IBlockState)state, (TileEntity)tile, (IMachineSidesProperties)MACHINESIDES_RENDERTYPE, SIDES);
        if (tile instanceof TileEntityDarkEnergyStorageCluster) {
            TileEntityDarkEnergyStorageCluster storageModule = (TileEntityDarkEnergyStorageCluster)tile;
            return state.func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(storageModule.scaledEnergyLevel));
        }
        if (tile instanceof TileEntityNuclearWasteStorageCluster) {
            TileEntityNuclearWasteStorageCluster storageModule = (TileEntityNuclearWasteStorageCluster)tile;
            return state.func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(storageModule.scaledEnergyLevel + 17));
        }
        return state.func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(0));
    }

    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMachineSides) {
            ((IMachineSides)tile).nextSideConfiguration(tile);
            return true;
        }
        return false;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> {
            if (itemStack.func_77952_i() == 0) {
                list.addAll(ItemDescriptionHelper.getDescription(this.func_149739_a() + "_0.description"));
            } else {
                list.addAll(ItemDescriptionHelper.getDescription(this.func_149739_a() + "_1.description"));
            }
        };
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("dark_energy", "nuclear_waste");
    }

    public static enum BlockType implements IStringSerializable
    {
        DARK_ENERGY_STORAGE_MODULE,
        NUCLEAR_WASTE_STORAGE_MODULE;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

