/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.util.ItemDescription;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockDescription;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.blocks.ISortableBlock;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;
import stevekung.mods.moreplanets.util.helper.ItemDescriptionHelper;

public class BlockShieldGenerator
extends BlockAdvancedTile
implements ISortableBlock,
ISingleBlockRender,
IBlockDescription {
    public BlockShieldGenerator(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
    }

    public CreativeTabs func_149708_J() {
        return MorePlanetsCore.BLOCK_TAB;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)MorePlanetsCore.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176746_e().func_176736_b();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShieldGenerator) {
            int direction = 0;
            if (change == 0) {
                direction = 180;
            }
            if (change == 1) {
                direction = -90;
            }
            if (change == 2) {
                direction = 0;
            }
            if (change == 3) {
                direction = 90;
            }
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            shield.setFacing(direction);
        }
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        int direction = 0;
        if (change == 0) {
            direction = 180;
        }
        if (change == 1) {
            direction = -90;
        }
        if (change == 2) {
            direction = 0;
        }
        if (change == 3) {
            direction = 90;
        }
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShieldGenerator) {
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            shield.setFacing(direction);
            shield.onCreate(world, pos);
            if (itemStack.func_77942_o()) {
                NBTTagCompound nbt = itemStack.func_77978_p();
                shield.storage.setEnergyStored(nbt.func_74760_g("EnergyStored"));
                shield.shieldSize = nbt.func_74760_g("ShieldSize");
                shield.maxShieldSize = nbt.func_74762_e("MaxShieldSize");
                shield.shieldDamage = nbt.func_74762_e("ShieldDamage");
                shield.maxShieldDamage = nbt.func_74762_e("MaxShieldDamage");
                shield.shieldCapacity = nbt.func_74762_e("ShieldCapacity");
                shield.maxShieldCapacity = nbt.func_74762_e("MaxShieldCapacity");
                shield.shieldChargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
                shield.needCharged = nbt.func_74767_n("NeedCharged");
                shield.enableShield = nbt.func_74767_n("EnableShield");
                shield.enableDamage = nbt.func_74767_n("EnableDamage");
                ItemStackHelper.func_191283_b((NBTTagCompound)itemStack.func_77978_p(), shield.containingItems);
            }
            if (placer instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)placer;
                shield.ownerUUID = player.func_146103_bH().getId().toString();
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityShieldGenerator) {
            ItemStack machine = new ItemStack((Block)this);
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("ShieldSize", shield.shieldSize);
            nbt.func_74768_a("MaxShieldSize", shield.maxShieldSize);
            nbt.func_74768_a("ShieldDamage", shield.shieldDamage);
            nbt.func_74768_a("MaxShieldDamage", shield.maxShieldDamage);
            nbt.func_74768_a("ShieldCapacity", shield.shieldCapacity);
            nbt.func_74768_a("MaxShieldCapacity", shield.maxShieldCapacity);
            nbt.func_74768_a("ShieldChargeCooldown", shield.shieldChargeCooldown);
            nbt.func_74757_a("NeedCharged", shield.needCharged);
            nbt.func_74757_a("EnableShield", shield.enableShield);
            nbt.func_74757_a("EnableDamage", shield.enableDamage);
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, shield.containingItems);
            if (shield.getEnergyStoredGC() > 0.0f) {
                nbt.func_74776_a("EnergyStored", shield.getEnergyStoredGC());
            }
            machine.func_77982_d(nbt);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShieldGenerator) {
            ((TileEntityShieldGenerator)tile).onDestroy(tile);
        }
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityShieldGenerator();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.FACING_HORIZON});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE_NON_BLOCK;
    }

    @Override
    public String getName() {
        return "shield_generator";
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(ItemDescriptionHelper.getDescription(this.func_149739_a() + ".description"));
    }
}

