/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNuclearWasteTank;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.moreplanets.util.blocks.BlockContainerMP;

public class BlockDummy
extends BlockContainerMP
implements IPartialSealableBlock {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockDummy(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
        this.func_149752_b(1.0E15f);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.WARP_PAD)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == BlockType.WARP_PAD) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        }
        if (state.func_177229_b(VARIANT) == BlockType.DARK_ENERGY_SOLAR1) {
            return new AxisAlignedBB(-0.25, 0.3, 0.3, 0.5, 0.6, 0.7);
        }
        if (state.func_177229_b(VARIANT) == BlockType.DARK_ENERGY_SOLAR2) {
            return new AxisAlignedBB(0.5, 0.3, 0.3, 1.25, 0.6, 0.7);
        }
        if (state.func_177229_b(VARIANT) == BlockType.DARK_ENERGY_SOLAR3) {
            return new AxisAlignedBB(0.3, 0.3, -0.25, 0.7, 0.6, 0.5);
        }
        if (state.func_177229_b(VARIANT) == BlockType.DARK_ENERGY_SOLAR4) {
            return new AxisAlignedBB(0.3, 0.3, 0.5, 0.7, 0.6, 1.25);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void makeFakeBlock(World world, BlockPos pos, BlockPos mainBlock, BlockType type) {
        world.func_180501_a(pos, MPBlocks.DUMMY_BLOCK.func_176203_a(type.ordinal()), 3);
        world.func_175625_s(pos).func_145834_a(world);
        ((TileEntityDummy)world.func_175625_s(pos)).setMainBlock(mainBlock);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
            TileEntity tileOther = world.func_175625_s(mainBlockPosition);
            if (tileOther instanceof TileEntityDarkEnergyReceiver) {
                TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tileOther;
                if ((dark.activated || dark.failed) && !dark.successful) {
                    return -1.0f;
                }
            }
            return world.func_180495_p(mainBlockPosition).func_177230_c().func_176195_g(state, world, mainBlockPosition);
        }
        return super.func_176195_g(state, world, pos);
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing facing) {
        if (world.func_180495_p(pos).func_177229_b(VARIANT) == BlockType.WARP_PAD) {
            return facing == EnumFacing.DOWN;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy) {
            ((TileEntityDummy)tileEntity).onBlockRemoval();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityDummy tileEntity = (TileEntityDummy)world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (tileEntity == null) {
            return false;
        }
        if (state.func_177229_b(VARIANT) == BlockType.NUCLEAR_WASTE_TANK_MIDDLE && world.func_180495_p(pos.func_177977_b()) == NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)BlockNuclearWasteTank.BlockType.NONE)) && !heldStack.func_190926_b() && heldStack.func_77973_b() == NibiruItems.WASTE_ROD_PICKER) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(NibiruItems.NUCLEAR_WASTE_ROD));
            world.func_175656_a(pos.func_177977_b(), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)BlockNuclearWasteTank.BlockType.NO_ROD)));
            return true;
        }
        if (state.func_177229_b(VARIANT) == BlockType.NUCLEAR_WASTE_TANK_TOP && world.func_180495_p(pos.func_177979_c(2)) == NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)BlockNuclearWasteTank.BlockType.NONE)) && !heldStack.func_190926_b() && heldStack.func_77973_b() == NibiruItems.WASTE_ROD_PICKER) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(NibiruItems.NUCLEAR_WASTE_ROD));
            world.func_175656_a(pos.func_177979_c(2), NibiruBlocks.NUCLEAR_WASTE_TANK.func_176223_P().func_177226_a(BlockNuclearWasteTank.STATE, (Comparable)((Object)BlockNuclearWasteTank.BlockType.NO_ROD)));
            return true;
        }
        return tileEntity.onBlockActivated(world, pos, player);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDummy();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Block mainBlock;
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) && Blocks.field_150350_a != (mainBlock = world.func_180495_p(mainBlockPosition).func_177230_c())) {
            return mainBlock.getPickBlock(state, target, world, mainBlockPosition, player);
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)new BlockPos(target.func_178782_a().func_177958_n(), target.func_178782_a().func_177956_o(), target.func_178782_a().func_177952_p()))) {
            manager.addBlockHitEffects(mainBlockPosition, target);
        }
        return super.addHitEffects(state, world, target, manager);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (state.func_177229_b(VARIANT) == BlockType.NUCLEAR_WASTE_TANK_TOP) {
            return super.func_193383_a(world, state, pos, facing);
        }
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        WARP_PAD,
        DARK_ENERGY_SOLAR1,
        DARK_ENERGY_SOLAR2,
        DARK_ENERGY_SOLAR3,
        DARK_ENERGY_SOLAR4,
        NUCLEAR_WASTE_TANK_MIDDLE,
        NUCLEAR_WASTE_TANK_TOP,
        SHIELD_GENERATOR_TOP;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.func_176610_l().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

