/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.expandedbonemeal;

import java.util.Random;
import josephcsible.expandedbonemeal.ZeroFirstIntRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="expandedbonemeal", version="1.2.1", acceptedMinecraftVersions="[1.9,)", guiFactory="josephcsible.expandedbonemeal.ExpandedBonemealGuiFactory")
public class ExpandedBonemeal {
    public static final String MODID = "expandedbonemeal";
    public static final String VERSION = "1.2.1";
    public static Configuration config;
    protected static int cactus;
    protected static int sugarcane;
    protected static boolean netherWart;
    protected static boolean melon;
    protected static boolean pumpkin;
    protected static boolean vine;
    protected static boolean lilyPad;
    protected static boolean deadBush;
    protected static boolean flowers;
    protected static boolean chorusFlower;
    protected static boolean mycelium;
    protected static boolean moss;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        ExpandedBonemeal.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            ExpandedBonemeal.syncConfig();
        }
    }

    protected static int getIntFormerBoolean(String key, String comment) {
        Property prop;
        boolean oldValue = true;
        ConfigCategory cat = config.getCategory("general");
        if (cat.containsKey(key) && (prop = cat.get(key)).getType() == Property.Type.BOOLEAN) {
            oldValue = prop.getBoolean();
            cat.remove((Object)key);
        }
        prop = config.get("general", key, 16, comment, 0, 16);
        if (!oldValue) {
            prop.set(0);
        }
        return prop.getInt();
    }

    protected static void syncConfig() {
        cactus = ExpandedBonemeal.getIntFormerBoolean("cactus", "How many stages bone meal should cause cacti to grow. 16 means always grow a new block, and 0 means bone meal doesn't work on cacti.");
        sugarcane = ExpandedBonemeal.getIntFormerBoolean("sugarcane", "How many stages bone meal should cause sugar canes to grow. 16 means always grow a new block, and 0 means bone meal doesn't work on sugar canes.");
        netherWart = config.get("general", "netherWart", true, "Whether using bone meal on nether wart should immediately advance it to the next growth stage").getBoolean();
        melon = config.get("general", "melon", true, "Whether using bone meal on a mature melon stem should immediately attempt to grow a melon").getBoolean();
        pumpkin = config.get("general", "pumpkin", true, "Whether using bone meal on a mature pumpkin stem should immediately attempt to grow a pumpkin").getBoolean();
        vine = config.get("general", "vine", true, "Whether using bone meal on a vine should immediately attempt to grow").getBoolean();
        lilyPad = config.get("general", "lilyPad", true, "Whether using bone meal on a lily pad should cause one to drop as an item").getBoolean();
        deadBush = config.get("general", "deadBush", true, "Whether using bone meal on sand or hardened clay should grow a dead bush").getBoolean();
        flowers = config.get("general", "flowers", true, "Whether using bone meal on flowers should cause one to drop as an item").getBoolean();
        chorusFlower = config.get("general", "chorusFlower", true, "Whether using bone meal on a chorus flower should immediately attempt to grow").getBoolean();
        mycelium = config.get("general", "mycelium", true, "Whether using bone meal on mycelium should cause mushrooms to grow").getBoolean();
        moss = config.get("general", "moss", true, "Whether using bone meal on cobblestone or stone bricks should cause moss to grow").getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    protected static void growCactusOrSugarcane(BonemealEvent event, IBlockState state, Block block, World world, PropertyInteger ageProperty, int stages) {
        BlockPos pos = event.getPos();
        while (world.func_180495_p(pos.func_177984_a()).func_177230_c() == block) {
            pos = pos.func_177984_a();
        }
        state = state.func_177226_a((IProperty)ageProperty, (Comparable)Integer.valueOf(Math.min((Integer)state.func_177229_b((IProperty)ageProperty) + stages - 1, 15)));
        world.func_180501_a(pos, state, 4);
        block.func_180650_b(world, pos, state, world.field_73012_v);
        event.setResult(Event.Result.ALLOW);
    }

    protected static void growMelonOrPumpkin(BonemealEvent event) {
        if ((Integer)event.getBlock().func_177229_b((IProperty)BlockStem.field_176484_a) == 7) {
            if (!event.getWorld().field_72995_K) {
                event.getBlock().func_177230_c().func_180650_b(event.getWorld(), event.getPos(), event.getBlock(), (Random)new ZeroFirstIntRandom());
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    protected static <T extends Comparable<T>> void changePropertyFromTo(BonemealEvent event, IProperty<T> property, T from, T to) {
        if (event.getBlock().func_177229_b(property) == from) {
            event.getWorld().func_180501_a(event.getPos(), event.getBlock().func_177226_a(property, to), 2);
            event.setResult(Event.Result.ALLOW);
        }
    }

    protected static void growMushrooms(BonemealEvent event) {
        BlockPos startpos = event.getPos().func_177984_a();
        World world = event.getWorld();
        Random rand = world.field_73012_v;
        block0: for (int attempt = 0; attempt < 16; ++attempt) {
            IBlockState state;
            BlockBush block;
            BlockPos pos = startpos;
            for (int moves = 0; moves < attempt / 2; ++moves) {
                if (world.func_180495_p((pos = pos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != Blocks.field_150391_bh || world.func_180495_p(pos).func_185915_l()) continue block0;
            }
            if (!world.func_175623_d(pos) || !(block = rand.nextInt(3) == 0 ? Blocks.field_150337_Q : Blocks.field_150338_P).func_180671_f(world, pos, state = block.func_176223_P())) continue;
            world.func_175656_a(pos, state);
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent event) {
        IBlockState state = event.getBlock();
        Block block = state.func_177230_c();
        World world = event.getWorld();
        if (block == Blocks.field_150434_aF) {
            if (cactus > 0) {
                ExpandedBonemeal.growCactusOrSugarcane(event, state, block, world, BlockCactus.field_176587_a, cactus);
            }
        } else if (block == Blocks.field_150436_aH) {
            if (sugarcane > 0) {
                ExpandedBonemeal.growCactusOrSugarcane(event, state, block, world, BlockReed.field_176355_a, sugarcane);
            }
        } else if (block == Blocks.field_150388_bm) {
            int age;
            if (netherWart && (age = ((Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) < 3) {
                world.func_180501_a(event.getPos(), state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1)), 2);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150394_bc) {
            if (melon) {
                ExpandedBonemeal.growMelonOrPumpkin(event);
            }
        } else if (block == Blocks.field_150393_bb) {
            if (pumpkin) {
                ExpandedBonemeal.growMelonOrPumpkin(event);
            }
        } else if (block == Blocks.field_150395_bd) {
            if (vine) {
                Random rand = world.field_73012_v;
                world.field_73012_v = new ZeroFirstIntRandom();
                block.func_180650_b(world, event.getPos(), state, rand);
                world.field_73012_v = rand;
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150392_bi) {
            if (lilyPad) {
                block.func_176226_b(world, event.getPos(), state, 0);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150354_m || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce) {
            if (deadBush && world.func_175623_d(event.getPos().func_177984_a())) {
                world.func_175656_a(event.getPos().func_177984_a(), Blocks.field_150330_I.func_176223_P());
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150328_O || block == Blocks.field_150327_N) {
            if (flowers) {
                block.func_176226_b(world, event.getPos(), state, 0);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_185766_cS) {
            int age;
            if (chorusFlower && (age = ((Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a)).intValue()) < 5) {
                if (!world.field_72995_K) {
                    block.func_180650_b(world, event.getPos(), state, (Random)new ZeroFirstIntRandom());
                }
                event.setResult(Event.Result.ALLOW);
            }
        } else if (block == Blocks.field_150391_bh) {
            if (mycelium) {
                ExpandedBonemeal.growMushrooms(event);
            }
        } else if (moss) {
            if (block == Blocks.field_150347_e) {
                world.func_180501_a(event.getPos(), Blocks.field_150341_Y.func_176223_P(), 2);
                event.setResult(Event.Result.ALLOW);
            } else if (block == Blocks.field_150463_bK) {
                ExpandedBonemeal.changePropertyFromTo(event, BlockWall.field_176255_P, BlockWall.EnumType.NORMAL, BlockWall.EnumType.MOSSY);
            } else if (block == Blocks.field_150417_aV) {
                ExpandedBonemeal.changePropertyFromTo(event, BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.DEFAULT, BlockStoneBrick.EnumType.MOSSY);
            } else if (block == Blocks.field_150418_aU) {
                ExpandedBonemeal.changePropertyFromTo(event, BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.STONEBRICK, BlockSilverfish.EnumType.MOSSY_STONEBRICK);
            }
        }
    }
}

