/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.IChiselFace;

public final class ChiselFace
implements IChiselFace {
    private List<ICTMTexture<?>> textureList;
    private TextureAtlasSprite particle;
    private List<IChiselFace> childFaces;

    public ChiselFace(ResourceLocation location) {
        this(new ArrayList(), new ArrayList<IChiselFace>());
    }

    public ChiselFace(List<ICTMTexture<?>> textureList, List<IChiselFace> childFaces) {
        this.textureList = textureList;
        this.childFaces = childFaces;
    }

    public List<ICTMTexture<?>> getTextureList() {
        ArrayList list = new ArrayList();
        list.addAll(this.textureList);
        for (IChiselFace face : this.childFaces) {
            list.addAll(face.getTextureList());
        }
        return list;
    }

    public void addTexture(ICTMTexture<?> texture) {
        this.textureList.add(texture);
    }

    public void addChildFace(IChiselFace face) {
        this.childFaces.add(face);
    }

    public boolean removeTexture(ICTMTexture<?> texture) {
        return this.textureList.remove(texture);
    }

    public boolean removeChildFace(IChiselFace face) {
        return this.childFaces.remove(face);
    }

    public TextureAtlasSprite getParticle() {
        if (this.particle == null) {
            this.particle = this.textureList.get(0) != null ? this.textureList.get(0).getParticle() : this.childFaces.get(0).getParticle();
        }
        return this.particle;
    }

    public void setParticle(TextureAtlasSprite sprite) {
        this.particle = sprite;
    }
}

