/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.entities;

import com.tmtravlr.jaff.ai.AIHelperLiquid;
import com.tmtravlr.jaff.ai.EntityAIFindBaitedHook;
import com.tmtravlr.jaff.ai.EntityAIFindBreedEntityItem;
import com.tmtravlr.jaff.ai.EntityAIFindLiquid;
import com.tmtravlr.jaff.ai.EntityAIFishAvoidEntity;
import com.tmtravlr.jaff.ai.FishMoveHelper;
import com.tmtravlr.jaff.ai.PathNavigateFish;
import com.tmtravlr.jaff.blocks.BlockTank;
import com.tmtravlr.jaff.entities.EntityIronFishHook;
import com.tmtravlr.jaff.items.ItemFishBucket;
import com.tmtravlr.jaff.utils.BaitType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityFish
extends EntityAnimal {
    public EntityAIBase taskFindLiquid;
    public EntityAIBase taskMate;
    public EntityAIBase taskFindBreedItem;
    public EntityAIBase taskFindBaitedHook;
    public EntityAIBase taskAvoidPlayer;
    public EntityAIBase taskWander;
    public EntityAIBase taskAttackPlayer;
    public EntityAIBase taskRevenge;
    public EntityAIBase taskTargetPlayer;
    public String[] baitTypes = new String[0];

    public EntityFish(World world) {
        super(world);
        this.func_70105_a(this.getBaseScale() / 4.0f, this.getBaseScale() / 4.0f);
        this.field_70765_h = new FishMoveHelper(this);
        if (this.lavaFish()) {
            this.field_70178_ae = true;
        }
    }

    protected void func_184651_r() {
        this.taskFindLiquid = new EntityAIFindLiquid(this, 0.4, !this.lavaFish(), this.lavaFish());
        this.taskMate = new EntityAIMate((EntityAnimal)this, 1.0);
        this.taskFindBreedItem = new EntityAIFindBreedEntityItem(this, 1.2, 8.0);
        this.taskFindBaitedHook = new EntityAIFindBaitedHook(this, 1.2, 24.0);
        this.taskAvoidPlayer = new EntityAIFishAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0);
        this.taskWander = new EntityAIWander((EntityCreature)this, 1.0, 10);
        this.taskAttackPlayer = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.taskRevenge = new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]);
        this.taskTargetPlayer = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true){

            public boolean func_75250_a() {
                if (!super.func_75250_a()) {
                    return false;
                }
                return !(this.field_75299_d instanceof EntityFish) || this.field_75299_d.func_70032_d((Entity)this.field_75309_a) < ((EntityFish)this.field_75299_d).attackRange();
            }
        };
        this.field_70714_bg.func_75776_a(11, this.taskFindLiquid);
        this.field_70714_bg.func_75776_a(12, this.taskMate);
        this.field_70714_bg.func_75776_a(21, this.taskFindBreedItem);
        this.field_70714_bg.func_75776_a(22, this.taskFindBaitedHook);
        this.field_70714_bg.func_75776_a(23, this.taskAttackPlayer);
        this.field_70714_bg.func_75776_a(31, this.taskAvoidPlayer);
        this.field_70714_bg.func_75776_a(32, this.taskWander);
        if (this.isHostile()) {
            this.field_70715_bh.func_75776_a(1, this.taskRevenge);
            this.field_70715_bh.func_75776_a(2, this.taskTargetPlayer);
        }
    }

    public abstract float getBaseScale();

    public abstract int getStrain();

    public abstract EntityFish createChild(EntityAgeable var1);

    public abstract ResourceLocation getTextureLocationBaby();

    public abstract ResourceLocation getTextureLocationAdult();

    public boolean lavaFish() {
        return false;
    }

    public boolean isHostile() {
        return false;
    }

    public float attackRange() {
        return 0.0f;
    }

    public void setBaitTypes(String ... types) {
        this.baitTypes = types;
    }

    public boolean isInTank() {
        return this.field_70170_p != null && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockTank;
    }

    public float getScale() {
        if (this.func_70874_b() < 0) {
            return 0.7f * this.getBaseScale();
        }
        return this.getBaseScale();
    }

    public float getScaleX() {
        return this.getScale();
    }

    public float getScaleY() {
        return this.getScale();
    }

    public float getScaleZ() {
        return this.getScale();
    }

    public boolean func_70877_b(ItemStack stack) {
        return BaitType.isBaitOfType(stack, this.baitTypes);
    }

    public boolean isBreedingItem(String type) {
        return BaitType.isBaitOfType(type, this.baitTypes);
    }

    public boolean canSpawnInLocation(World world, int x, int y, int z) {
        return true;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_95999_t());
        }
        return super.func_70099_a(stack, offsetY);
    }

    @Nullable
    public ResourceLocation getDropLootTable() {
        return this.func_184647_J();
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFish((EntityLiving)this, worldIn);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ());
    }

    protected boolean func_70692_ba() {
        return !this.isInTank();
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187684_cg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187684_cg;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.8f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.6f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        tag.func_74776_a("MoveVertical", this.field_70701_bs);
        return tag;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.field_70701_bs = tag.func_74760_g("MoveVertical");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack fishBucket;
        super.func_184645_a(player, hand);
        if (ItemFishBucket.canFishGoInBucket(this) && !(fishBucket = ItemFishBucket.createFromFish(this)).func_190926_b()) {
            Item pickupItem = fishBucket.func_77973_b().func_77668_q();
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() == pickupItem) {
                this.func_70106_y();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, fishBucket);
                return true;
            }
        }
        return false;
    }

    public void func_191986_a(float moveStrafing, float moveUp, float moveForward) {
        double prevMotionY = this.field_70181_x;
        super.func_191986_a(moveStrafing, moveUp, moveForward);
        if (AIHelperLiquid.isInLiquid((Entity)this) && !this.func_189652_ae()) {
            this.field_70181_x += 0.02;
        }
        this.field_184619_aG -= this.field_70721_aZ;
        this.field_70721_aZ = this.field_184618_aE;
        double distX = this.field_70165_t - this.field_70169_q;
        double distY = this.field_70163_u - this.field_70167_r;
        double distZ = this.field_70161_v - this.field_70166_s;
        float distTotal = MathHelper.func_76133_a((double)(distX * distX + distY * distY + distZ * distZ)) * 4.0f;
        if (distTotal > 1.0f) {
            distTotal = 1.0f;
        }
        this.field_70721_aZ += (distTotal - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_180799_ab() {
        return this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151587_i);
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151586_h);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.isHostile()) {
            return super.func_70652_k(entityIn);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public float func_180484_a(BlockPos pos) {
        Material material = this.field_70170_p.func_180495_p(pos).func_185904_a();
        return !this.lavaFish() && material == Material.field_151586_h || this.lavaFish() && material == Material.field_151587_i ? 1.0f : 0.0f;
    }

    public void func_70071_h_() {
        if (this.func_70089_S() && !AIHelperLiquid.isInLiquid((Entity)this)) {
            if (this.field_70721_aZ <= 0.0f) {
                this.field_70721_aZ = 1.5f;
            }
            if (this.field_70721_aZ > 0.0f) {
                this.field_70721_aZ = 1.5f;
            }
            if (this.field_70122_E && this.field_70725_aQ == 0) {
                this.func_184185_a(SoundEvents.field_187684_cg, this.func_70599_aP(), this.func_70647_i());
            }
        }
        if (this.func_70613_aW()) {
            if (this.func_70874_b() == 0 && !this.func_70880_s() && this.field_70173_aa % 10 == 0) {
                List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(0.8));
                for (EntityItem item : list) {
                    if (this.func_70880_s() || !item.func_70089_S() || !this.func_70877_b(item.func_92059_d())) continue;
                    this.func_146082_f(null);
                    item.func_92059_d().func_190918_g(1);
                    if (!item.func_92059_d().func_190926_b()) break;
                    item.func_70106_y();
                    break;
                }
            }
            if (this.func_70874_b() >= 0 && this.field_70173_aa % 10 == 0) {
                List hookList = this.field_70170_p.func_72872_a(EntityIronFishHook.class, this.func_174813_aQ().func_72314_b(1.0, 1.8, 1.0));
                for (EntityIronFishHook hook : hookList) {
                    if (hook.field_146043_c != null) continue;
                    hook.hookEntity((Entity)this);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    break;
                }
            }
        }
        super.func_70071_h_();
        this.field_191988_bg *= 0.5f;
        if (!this.func_70613_aW()) {
            double distX = this.field_70165_t - this.field_70169_q;
            double distY = this.field_70163_u - this.field_70167_r;
            double distZ = this.field_70161_v - this.field_70166_s;
            double distH = Math.sqrt(distX * distX + distZ * distZ);
            float newRotationPitch = 0.0f;
            if (distH != 0.0) {
                newRotationPitch = (float)(Math.atan(distY / distH) * 57.29577951308232);
            } else {
                if (distY > 0.0) {
                    newRotationPitch = 90.0f;
                }
                if (distY < 0.0) {
                    newRotationPitch = -90.0f;
                }
            }
            MathHelper.func_76131_a((float)newRotationPitch, (float)-90.0f, (float)90.0f);
            this.field_70127_C = this.field_70125_A;
            this.field_70125_A = (this.field_70125_A * 3.0f + newRotationPitch) / 4.0f;
        }
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70613_aW()) {
            if (this.func_70089_S() && !AIHelperLiquid.isInLiquid((Entity)this)) {
                if (--i <= -20) {
                    i = 0;
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
                this.func_70050_g(i);
            } else {
                this.func_70050_g(300);
            }
        }
    }
}

