/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static float inSet = 0.0625f;
    private AxisAlignedBB boundingBox = Block.field_185505_j;

    public BlockTank() {
        super(Material.field_151586_h);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        boolean down;
        boolean bl = down = !this.canConnectTo(world, pos.func_177977_b());
        if (down) {
            return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)((float)pos.func_177956_o() + inSet), (double)pos.func_177952_p() + 1.0);
        }
        return null;
    }

    public boolean canConnectTo(IBlockAccess iba, BlockPos pos) {
        if (iba == null) {
            return false;
        }
        return iba.func_180495_p(pos).func_177230_c() instanceof BlockTank;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public void setBlockBounds(double xStart, double yStart, double zStart, double xEnd, double yEnd, double zEnd) {
        this.boundingBox = new AxisAlignedBB(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, @Nullable Entity entity, boolean fromCollision) {
        AxisAlignedBB bound;
        float zMax;
        boolean north = !this.canConnectTo((IBlockAccess)world, pos.func_177978_c());
        boolean south = !this.canConnectTo((IBlockAccess)world, pos.func_177968_d());
        boolean east = !this.canConnectTo((IBlockAccess)world, pos.func_177974_f());
        boolean west = !this.canConnectTo((IBlockAccess)world, pos.func_177976_e());
        boolean down = !this.canConnectTo((IBlockAccess)world, pos.func_177977_b());
        float biggerInSet = inSet * 2.0f;
        float xMin = west ? biggerInSet : 0.0f;
        float xMax = east ? 1.0f - biggerInSet : 1.0f;
        float yMin = down ? biggerInSet : 0.0f;
        float zMin = north ? biggerInSet : 0.0f;
        float f = zMax = south ? 1.0f - biggerInSet : 1.0f;
        if (west && (bound = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + (double)xMin, (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) != null && aabb.func_72326_a(bound)) {
            list.add(bound);
        }
        if (east && (bound = new AxisAlignedBB((double)pos.func_177958_n() + (double)xMax, (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) != null && aabb.func_72326_a(bound)) {
            list.add(bound);
        }
        if (north && (bound = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + (double)zMin)) != null && aabb.func_72326_a(bound)) {
            list.add(bound);
        }
        if (south && (bound = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + (double)zMax, (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) != null && aabb.func_72326_a(bound)) {
            list.add(bound);
        }
        if (down && (bound = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + (double)yMin, (double)(pos.func_177952_p() + 1))) != null && aabb.func_72326_a(bound)) {
            list.add(bound);
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        ArrayList<AxisAlignedBB> collisionBoxList = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB searchBoundingBox = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        this.func_185477_a(world.func_180495_p(pos), world, pos, searchBoundingBox, collisionBoxList, null, false);
        RayTraceResult positionToReturn = null;
        for (AxisAlignedBB bb : collisionBoxList) {
            this.setBlockBounds((float)bb.field_72340_a - (float)pos.func_177958_n(), (float)bb.field_72338_b - (float)pos.func_177956_o(), (float)bb.field_72339_c - (float)pos.func_177952_p(), (float)bb.field_72336_d - (float)pos.func_177958_n(), (float)bb.field_72337_e - (float)pos.func_177956_o(), (float)bb.field_72334_f - (float)pos.func_177952_p());
            RayTraceResult current = super.func_180636_a(state, world, pos, startVec, endVec);
            if (current == null) continue;
            if (positionToReturn == null || positionToReturn.field_72313_a == RayTraceResult.Type.MISS) {
                positionToReturn = current;
                continue;
            }
            if (current.field_72313_a == RayTraceResult.Type.MISS || !(startVec.func_72438_d(current.field_72307_f) < startVec.func_72438_d(positionToReturn.field_72307_f))) continue;
            positionToReturn = current;
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return positionToReturn;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177977_b()))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177984_a()))).func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, DOWN, UP, BlockLiquid.field_176367_b});
    }
}

