/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff;

import com.tmtravlr.jaff.ConfigOptions;
import com.tmtravlr.jaff.blocks.BlockTank;
import com.tmtravlr.jaff.entities.EntityFish;
import com.tmtravlr.jaff.utils.FishSpawning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class JAFFEventHandler {
    public static ArrayList<FishSpawning> spawnTypesWater = new ArrayList();
    public static ArrayList<FishSpawning> spawnTypesLava = new ArrayList();
    private static final int maxNumberOfCreature = 20;
    private int spawnTime = 0;
    private HashMap<ChunkPos, Boolean> eligibleChunksForSpawning = new HashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBucketFillHighPriority(FillBucketEvent event) {
        if (!event.isCanceled() && event.getTarget() != null && event.getWorld() != null && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getWorld().func_180495_p(event.getTarget().func_178782_a()).func_177230_c() instanceof BlockTank) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if ((!spawnTypesLava.isEmpty() || !spawnTypesWater.isEmpty()) && event.world.func_82736_K().func_82766_b("doMobSpawning") && event.phase == TickEvent.Phase.START && event.world instanceof WorldServer) {
            this.trySpawningFish((WorldServer)event.world);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int trySpawningFish(WorldServer world) {
        if (++this.spawnTime < ConfigOptions.spawnFrequency) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        for (EntityPlayer player : world.field_73010_i) {
            chunkX = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            chunkZ = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            spawnRange = 8;
            for (x = -spawnRange; x <= spawnRange; ++x) {
                for (z = -spawnRange; z <= spawnRange; ++z) {
                    isEdge = x == -spawnRange || x == spawnRange || z == -spawnRange || z == spawnRange;
                    chunkCoord = new ChunkPos(x + chunkX, z + chunkZ);
                    if (!isEdge) {
                        this.eligibleChunksForSpawning.put(chunkCoord, false);
                        continue;
                    }
                    if (this.eligibleChunksForSpawning.containsKey(chunkCoord)) continue;
                    this.eligibleChunksForSpawning.put(chunkCoord, true);
                }
            }
        }
        numberSpawned = 0;
        spawnCoords = world.func_175694_M();
        if (this.countAllFish(world.func_73046_m()) <= ConfigOptions.spawnFrequency * this.eligibleChunksForSpawning.size() / 256) {
            chunks = new ArrayList<ChunkPos>(this.eligibleChunksForSpawning.keySet());
            Collections.shuffle(chunks);
            block5: for (ChunkPos chunkCoord : chunks) {
                if (this.eligibleChunksForSpawning.get(chunkCoord).booleanValue()) continue;
                chunkPos = this.getRandomSpawningPointInChunk((World)world, chunkCoord.field_77276_a, chunkCoord.field_77275_b);
                x = chunkPos.func_177958_n();
                y = chunkPos.func_177956_o();
                z = chunkPos.func_177952_p();
                if (world.func_175677_d(chunkPos, true)) continue;
                groupRadius = 6;
                groupSpawnAttempt = 3;
                if (groupSpawnAttempt-- <= 0) {
                    return numberSpawned;
                }
                X = x;
                Y = y;
                Z = z;
                spawnlistentry = null;
                spawnAttempt = 4;
                block6: while (true) {
                    if (spawnAttempt-- <= 0) {
                        return numberSpawned;
                    }
                    pos = new BlockPos(X += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius), Y += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), Z += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius));
                    lava = false;
                    index = 0;
                    while (true) {
                        if (index >= 2) continue block6;
                        if (JAFFEventHandler.canFishSpawnAtLocation((World)world, pos, lava) && world.func_184137_a((double)(posX = (float)X + 0.5f), (double)(posY = (float)Y), (double)(posZ = (float)Z + 0.5f), 24.0, false) == null && (spawnDist = (spawnX = posX - (float)spawnCoords.func_177958_n()) * spawnX + (spawnY = posY - (float)spawnCoords.func_177956_o()) * spawnY + (spawnZ = posZ - (float)spawnCoords.func_177952_p()) * spawnZ) >= 576.0f) {
                            if (spawnlistentry != null || (spawnlistentry = this.setSpawnPotentials((World)world, pos, lava)) != null) ** break;
                            continue block6;
                            try {
                                entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(new Class[]{World.class}).newInstance(new Object[]{world});
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return numberSpawned;
                            }
                            entityliving.func_70012_b((double)posX, (double)posY, (double)posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            groupSpawned = 0;
                            canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)posX, (float)posY, (float)posZ);
                            if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi()) {
                                ++groupSpawned;
                                world.func_72838_d((Entity)entityliving);
                                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)world, (float)posX, (float)posY, (float)posZ)) {
                                    entityliving.func_180482_a(world.func_175649_E(pos), null);
                                }
                                if (groupSpawned >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block5;
                            }
                            numberSpawned += groupSpawned;
                        }
                        ++index;
                        lava = true;
                    }
                    break;
                }
            }
        }
        return numberSpawned;
    }

    public Biome.SpawnListEntry setSpawnPotentials(World world, BlockPos pos, boolean lava) {
        ArrayList<Biome.SpawnListEntry> list = new ArrayList<Biome.SpawnListEntry>();
        if (!lava && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h || lava && world.func_180495_p(pos).func_185904_a() == Material.field_151587_i) {
            for (FishSpawning logic : lava ? spawnTypesLava : spawnTypesWater) {
                if (!logic.canSpawnHere(world, pos)) continue;
                logic.addSpawning(world, pos, list);
            }
        }
        return list != null && !list.isEmpty() ? (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, list) : null;
    }

    public static boolean canFishSpawnAtLocation(World world, BlockPos pos, boolean lava) {
        return lava && world.func_180495_p(pos).func_185904_a() == Material.field_151587_i || !lava && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    private BlockPos getRandomSpawningPointInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
        int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(x, y, z);
    }

    private int countAllFish(MinecraftServer server) {
        int fishCount = 0;
        if (server != null) {
            for (WorldServer world : server.field_71305_c) {
                fishCount += world.func_72907_a(EntityFish.class);
            }
        }
        return fishCount;
    }
}

