/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff;

import com.tmtravlr.jaff.JAFFMod;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;

public class ConfigOptions {
    public static Configuration config;
    public static int spawnFrequency;
    public static boolean enableCod;
    public static boolean enableSalmon;
    public static boolean enableClownfish;
    public static boolean enablePufferfish;
    public static boolean simpleFishing;
    public static ArrayList<Integer> dimensionBlacklist;
    public static ArrayList<Integer> dimensionWhitelist;
    public static ArrayList<Block> fluidBlacklist;
    public static ArrayList<Block> fluidWhitelist;
    public static ArrayList<ItemStack> wormList;
    public static boolean DEBUG;

    public static void loadConfig() {
        config.load();
        spawnFrequency = config.getInt("Spawn Frequency", "spawning", spawnFrequency, 1, 2000, "The spawn frequency for the fish: higher is more common.");
        enableCod = config.getBoolean("Enable Cod Spawning", "spawning", true, "Set to false to prevent Cod from spawning.");
        enableSalmon = config.getBoolean("Enable Salmon Spawning", "spawning", true, "Set to false to prevent Salmon from spawning.");
        enableClownfish = config.getBoolean("Enable Clownfish Spawning", "spawning", true, "Set to false to prevent Clownfish from spawning.");
        enablePufferfish = config.getBoolean("Enable Pufferfish Spawning", "spawning", true, "Set to false to prevent Pufferfish from spawning.");
        simpleFishing = config.getBoolean("Simple Fishing", "fishing", simpleFishing, "If this is true, when you hook a fish and right click, you\ncatch it immediately, instead of reeling it in.");
        String entries = config.getString("Dimension Blacklist", "restrictions", "-1,1", "Comma separated list of dimension ids which the fish should not spawn in.");
        if (entries != null && !entries.isEmpty()) {
            dimensionBlacklist.addAll(ConfigOptions.getIntegerList(entries));
        }
        if ((entries = config.getString("Dimension Whitelist", "restrictions", "", "Comma separated list of dimension ids which the fish can only spawn in.\nOverrides the blacklist if not empty.")) != null && !entries.isEmpty()) {
            dimensionWhitelist.addAll(ConfigOptions.getIntegerList(entries));
        }
        fluidBlacklist.add(JAFFMod.tank);
        String[] entryArray = config.getStringList("Fluid Blacklist", "restrictions", new String[]{"BiomesOPlenty:poison", "BuildCraft|Energy:blockOil"}, "List of fluid blocks which the fish should not spawn in.");
        if (entryArray.length != 0) {
            fluidBlacklist.addAll(ConfigOptions.getBlockList(entryArray));
        }
        if ((entryArray = config.getStringList("Fluid Whitelist", "restrictions", new String[0], "List of fluid blocks which the fish can only spawn in.\nOverrides the blacklist if not empty.")).length != 0) {
            fluidWhitelist.addAll(ConfigOptions.getBlockList(entryArray));
        }
        if ((entryArray = config.getStringList("Worm Bait", "bait", new String[0], "List if items considered worms, which can be used as bait.\nAdd them each on a new line in the form <Item Name>-<Metadata (optional)>\nso for example something like somemod:worm_item-0. If you don't put the\nmetadata, it uses any metadata.")).length != 0) {
            wormList.addAll(ConfigOptions.getItemStackList(entryArray));
        }
        config.save();
    }

    private static ArrayList<Integer> getIntegerList(String entries) {
        String[] integers = entries.split(",");
        ArrayList<Integer> toReturn = new ArrayList<Integer>();
        for (String intString : integers) {
            try {
                toReturn.add(Integer.parseInt(intString));
            }
            catch (NumberFormatException e) {
                FMLLog.warning((String)"[Just a Few Fish] Invalid integer '%s'!", (Object[])new Object[]{intString});
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    private static ArrayList<Block> getBlockList(String[] entryArray) {
        ArrayList<Block> toReturn = new ArrayList<Block>();
        for (String entry : entryArray) {
            Block block = Block.func_149684_b((String)entry);
            if (block != null && block != Blocks.field_150350_a) {
                toReturn.add(block);
                continue;
            }
            FMLLog.warning((String)"[Just a Few Fish] Couldn't find a block with the name '%s'!", (Object[])new Object[]{entry});
        }
        return toReturn;
    }

    private static ArrayList<ItemStack> getItemStackList(String[] entryArray) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (String entry : entryArray) {
            String[] split = entry.split("-");
            String name = split.length > 0 ? split[0] : "";
            String metaString = split.length > 1 ? split[1] : null;
            int meta = Short.MAX_VALUE;
            Object item = Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item == null) {
                FMLLog.warning((String)"[Just a Few Fish] Couldn't find an item with the name '%s'!", (Object[])new Object[]{entry});
                continue;
            }
            if (metaString != null) {
                try {
                    meta = Integer.parseInt(metaString);
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)"[Just a Few Fish] Invalid integer '%s'!", (Object[])new Object[]{metaString});
                    e.printStackTrace();
                    continue;
                }
            }
            toReturn.add(new ItemStack((Item)item, 1, meta));
        }
        return toReturn;
    }

    static {
        spawnFrequency = 100;
        enableCod = true;
        enableSalmon = true;
        enableClownfish = true;
        enablePufferfish = true;
        simpleFishing = false;
        dimensionBlacklist = new ArrayList();
        dimensionWhitelist = new ArrayList();
        fluidBlacklist = new ArrayList();
        fluidWhitelist = new ArrayList();
        wormList = new ArrayList();
        DEBUG = false;
    }
}

