/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.GuiRadialMenu;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.KeyReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class KeyboardHandler {
    public static final KeyboardHandler INSTANCE = new KeyboardHandler();
    private static final KeyBinding WHEEL = new KeyBinding("key.open_menu", 19, "key.categories.misc");
    private static boolean lastWheelState = false;
    private static final List<KeyBinding> FIRED_KEYS = new ArrayList<KeyBinding>();
    private static final List<KeyBinding> TOGGLED_KEYS = new ArrayList<KeyBinding>();
    private static boolean ignoreNextTick = false;

    public static void register() {
        ClientRegistry.registerKeyBinding((KeyBinding)WHEEL);
    }

    private KeyboardHandler() {
    }

    public void fireKey(KeyBinding key) {
        FIRED_KEYS.add(key);
        KeyReflectionHelper.pressKey(key);
        KeyReflectionHelper.increasePressTime(key);
        boolean old = Minecraft.func_71410_x().field_71415_G;
        Minecraft.func_71410_x().field_71415_G = true;
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent());
        Minecraft.func_71410_x().field_71415_G = old;
        ignoreNextTick = true;
    }

    public void toggleKey(KeyBinding key) {
        if (!TOGGLED_KEYS.contains(key)) {
            TOGGLED_KEYS.add(key);
            KeyReflectionHelper.pressKey(key);
            KeyReflectionHelper.increasePressTime(key);
        } else {
            TOGGLED_KEYS.remove(key);
            KeyReflectionHelper.unpressKey(key);
        }
        boolean old = Minecraft.func_71410_x().field_71415_G;
        Minecraft.func_71410_x().field_71415_G = true;
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent());
        Minecraft.func_71410_x().field_71415_G = old;
        ignoreNextTick = true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        KeyBinding keyBinding;
        boolean wheelKeyPressed;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        boolean bl = wheelKeyPressed = WHEEL.func_151463_i() >= 0 ? Keyboard.isKeyDown((int)WHEEL.func_151463_i()) : Mouse.isButtonDown((int)(WHEEL.func_151463_i() + 100));
        if (wheelKeyPressed != lastWheelState) {
            if (ConfigHandler.toggle) {
                if (wheelKeyPressed) {
                    if (GuiRadialMenu.active) {
                        if (ConfigHandler.releaseToSelect) {
                            GuiRadialMenu.INSTANCE.func_73864_a(Mouse.getX(), Mouse.getY(), 0);
                        }
                        GuiRadialMenu.deactivate();
                    } else if (mc.field_71462_r == null || mc.field_71462_r instanceof GuiRadialMenu) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        GuiRadialMenu.activate();
                    }
                }
            } else if (wheelKeyPressed != GuiRadialMenu.active) {
                if (wheelKeyPressed) {
                    if (mc.field_71462_r == null || mc.field_71462_r instanceof GuiRadialMenu) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        GuiRadialMenu.activate();
                    }
                } else {
                    if (ConfigHandler.releaseToSelect) {
                        GuiRadialMenu.INSTANCE.func_73864_a(Mouse.getX(), Mouse.getY(), 0);
                    }
                    GuiRadialMenu.deactivate();
                }
            }
        }
        lastWheelState = wheelKeyPressed;
        if (ignoreNextTick) {
            ignoreNextTick = false;
            return;
        }
        Iterator<KeyBinding> iterator = FIRED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            KeyReflectionHelper.unpressKey(keyBinding);
            iterator.remove();
        }
        iterator = TOGGLED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            if (!(keyBinding.func_151463_i() >= 0 ? Keyboard.isKeyDown((int)keyBinding.func_151463_i()) : Mouse.isButtonDown((int)(keyBinding.func_151463_i() + 100)))) continue;
            iterator.remove();
        }
        for (KeyBinding keyBinding2 : TOGGLED_KEYS) {
            KeyReflectionHelper.increasePressTime(keyBinding2);
        }
    }
}

