/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityConcussionCreeper;
import crazypants.enderzoo.entity.EntityDireSlime;
import crazypants.enderzoo.entity.EntityDireWolf;
import crazypants.enderzoo.entity.EntityEnderminy;
import crazypants.enderzoo.entity.EntityFallenKnight;
import crazypants.enderzoo.entity.EntityFallenMount;
import crazypants.enderzoo.entity.EntityOwl;
import crazypants.enderzoo.entity.EntityWitherCat;
import crazypants.enderzoo.entity.EntityWitherWitch;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;

public enum MobInfo {
    ENDERMINY(EntityEnderminy.class, "enderminy", 2581069, 0x212121, Config.enderminyEnabled, Config.enderminyHealth, Config.enderminyAttackDamage, Config.enderminyId),
    CONCUSSION_CREEPER(EntityConcussionCreeper.class, "concussioncreeper", 5701518, 16714274, Config.concussionCreeperEnabled, Config.concussionCreeperHealth, 4.0, Config.concussionCreeperId),
    FALLEN_KNIGHT(EntityFallenKnight.class, "fallenknight", 0xA0A0A0, 3562021, Config.fallenKnightEnabled, Config.fallenKnightHealth, Config.fallenKnightBaseDamage, Config.fallenKnightId),
    FALLEN_MOUNT(EntityFallenMount.class, "fallenmount", 3562021, 0xA0A0A0, Config.fallenMountEnabled, Config.fallenMountHealth, Config.fallenMountBaseAttackDamage, Config.fallenMountId),
    WITHER_WITCH(EntityWitherWitch.class, "witherwitch", 2511373, 9461315, Config.witherWitchEnabled, Config.witherWitchHealth, 4.0, Config.witherWitchId),
    WITHER_CAT(EntityWitherCat.class, "withercat", 0x303030, 0xFFFFFF, Config.witherCatEnabled, Config.witherCatHealth, Config.witherCatAttackDamage, Config.witherCatId),
    DIRE_WOLF(EntityDireWolf.class, "direwolf", 0x606060, 0xA0A0A0, Config.direWolfEnabled, Config.direWolfHealth, Config.direWolfAttackDamage, Config.direWolfId),
    DIRE_SLIME(EntityDireSlime.class, "direslime", 12158300, 5848361, Config.direSlimeEnabled, Config.direSlimeHealth, Config.direSlimeAttackDamage, Config.direSlimeId),
    OWL(EntityOwl.class, "owl", 12679497, 16768454, Config.owlEnabled, Config.owlHealth, Config.owlAttachDamage, Config.owlId);

    final Class<? extends EntityLiving> clz;
    final String name;
    final int bgCol;
    final int fgCol;
    final boolean enabled;
    final double maxHealth;
    final double attackDamage;
    final int entityId;

    public static boolean isDisabled(Class<? extends EntityLiving> clz) {
        if (clz == null) {
            return false;
        }
        for (MobInfo info : MobInfo.values()) {
            if (clz != info.getClz() || info.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private MobInfo(Class<? extends EntityLiving> clz, String name, int bgCol, int fgCol, boolean enabled, double baseHealth, double baseAttack, int entityId) {
        this.clz = clz;
        this.name = name;
        this.bgCol = bgCol;
        this.fgCol = fgCol;
        this.enabled = enabled;
        this.entityId = entityId;
        this.maxHealth = baseHealth;
        this.attackDamage = baseAttack;
    }

    public Class<? extends EntityLiving> getClz() {
        return this.clz;
    }

    public String getName() {
        return this.name;
    }

    public int getEggBackgroundColor() {
        return this.bgCol;
    }

    public int getEggForegroundColor() {
        return this.fgCol;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void applyAttributes(EntityLivingBase entity) {
        entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.maxHealth);
        IAttributeInstance ai = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (ai == null) {
            entity.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            ai = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        }
        ai.func_111128_a(this.attackDamage);
    }

    public int getEntityId() {
        return this.entityId;
    }
}

