/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.IFlyingMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.ai.EntityAIFlyingAttackOnCollide;
import crazypants.enderzoo.entity.ai.EntityAIFlyingFindPerch;
import crazypants.enderzoo.entity.ai.EntityAIFlyingLand;
import crazypants.enderzoo.entity.ai.EntityAIFlyingPanic;
import crazypants.enderzoo.entity.ai.EntityAIFlyingShortWander;
import crazypants.enderzoo.entity.ai.EntityAINearestAttackableTargetBounded;
import crazypants.enderzoo.entity.navigate.FlyingMoveHelper;
import crazypants.enderzoo.entity.navigate.FlyingPathNavigate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityOwl
extends EntityAnimal
implements IFlyingMob {
    public static final String NAME = "owl";
    public static final int EGG_BG_COL = 12679497;
    public static final int EGG_FG_COL = 16768454;
    public static final SoundEvent SND_HOOT = new SoundEvent(new ResourceLocation("enderzoo", "owl.hootSingle"));
    public static final SoundEvent SND_HOOT2;
    public static final SoundEvent SND_HURT;
    private float wingRotation;
    private float prevWingRotation;
    private float wingRotDelta = 1.0f;
    private float destPos;
    private float prevDestPos;
    private float bodyAngle = 5.0f;
    private float targetBodyAngle = 0.0f;
    private float wingAngle;
    private double groundSpeedRatio = 0.25;
    private float climbRate = 0.25f;
    private float turnRate = 30.0f;
    public int timeUntilNextEgg;

    public EntityOwl(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.85f);
        this.field_70138_W = 1.0f;
        int pri = 0;
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingAttackOnCollide(this, 2.5, false));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151070_bp, false));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.5));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingLand((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingFindPerch((EntityCreature)this, 2.0, 80));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIFlyingShortWander((EntityCreature)this, 2.0, 150));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(++pri, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        EntityAINearestAttackableTargetBounded<EntitySpider> targetSpiders = new EntityAINearestAttackableTargetBounded<EntitySpider>((EntityCreature)this, EntitySpider.class, true, true);
        targetSpiders.setMaxDistanceToTarget(12.0);
        targetSpiders.setMaxVerticalDistanceToTarget(24.0);
        this.field_70715_bh.func_75776_a(0, targetSpiders);
        this.field_70765_h = new FlyingMoveHelper(this);
        this.timeUntilNextEgg = this.getNextLayingTime();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        MobInfo.OWL.applyAttributes((EntityLivingBase)this);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new FlyingPathNavigate((EntityLiving)this, worldIn);
    }

    @Override
    public FlyingPathNavigate getFlyingNavigator() {
        return (FlyingPathNavigate)this.func_70661_as();
    }

    public float func_180484_a(BlockPos pos) {
        IBlockState bs = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return bs.func_185904_a() == Material.field_151584_j ? 10.0f : 0.0f;
    }

    public boolean func_70652_k(Entity entityIn) {
        super.func_70652_k(entityIn);
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entityIn instanceof EntitySpider) {
            attackDamage *= Config.owlSpiderDamageMultiplier;
        }
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
    }

    public void func_70636_d() {
        AxisAlignedBB bb;
        super.func_70636_d();
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        float flapSpeed = 2.0f;
        double yDelta = Math.abs(this.field_70163_u - this.field_70167_r);
        if (yDelta != 0.0) {
            yDelta = Math.min(1.0, yDelta / 0.02);
            yDelta = Math.max(yDelta, 0.75);
            flapSpeed = (float)((double)flapSpeed * yDelta);
        }
        this.wingRotation += this.wingRotDelta * flapSpeed;
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            if (this.isOnLeaves()) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_145779_a(EnderZoo.itemOwlEgg, 1);
            }
            this.timeUntilNextEgg = this.getNextLayingTime();
        }
        AxisAlignedBB movedBB = this.func_174813_aQ().func_72317_d(0.0, this.field_70181_x, 0.0);
        BlockPos ep = this.func_180425_c();
        BlockPos pos = new BlockPos((double)ep.func_177958_n(), movedBB.field_72337_e, (double)ep.func_177952_p());
        IBlockState bs = this.field_70170_p.func_180495_p(pos);
        if (bs.func_185904_a() != Material.field_151579_a && (bb = bs.func_185890_d((IBlockAccess)this.field_70170_p, pos)) != null) {
            double ouch = movedBB.field_72337_e - bb.field_72338_b;
            this.field_70181_x = ouch == 0.0 ? -0.1 : 0.0;
        }
        if (this.field_70122_E) {
            this.field_70159_w *= this.groundSpeedRatio;
            this.field_70179_y *= this.groundSpeedRatio;
        }
    }

    private boolean isOnLeaves() {
        IBlockState bs = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
        return bs.func_185904_a() == Material.field_151584_j;
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int i = 0; i < 8; ++i) {
            int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
            int y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
            if ((double)y > this.func_174813_aQ().field_72337_e) {
                y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e);
            }
            int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
            if (pos.func_177958_n() == x && pos.func_177956_o() == y && pos.func_177952_p() == z) continue;
            pos.func_181079_c(x, y, z);
            if (!this.field_70170_p.func_180495_p((BlockPos)pos).func_185914_p()) continue;
            return true;
        }
        return false;
    }

    private void calculateWingAngle(float partialTicks) {
        float flapComletion = this.prevWingRotation + (this.wingRotation - this.prevWingRotation) * partialTicks;
        float onGroundTimerThing = this.prevDestPos + (this.destPos - this.prevDestPos) * partialTicks;
        this.wingAngle = (MathHelper.func_76126_a((float)flapComletion) + 1.0f) * onGroundTimerThing;
        if (this.field_70122_E) {
            this.wingAngle = (float)Math.toRadians(3.0);
        }
    }

    private void calculateBodyAngle(float partialTicks) {
        if (this.field_70122_E) {
            this.bodyAngle = 7.0f;
            this.targetBodyAngle = 7.0f;
            return;
        }
        Vec3d motionVec = new Vec3d(this.field_70159_w, 0.0, this.field_70179_y);
        double speed = motionVec.func_72433_c();
        speed = Math.min(1.0, speed * 10.0);
        this.targetBodyAngle = 20.0f + (float)speed * 30.0f;
        if (this.targetBodyAngle == this.bodyAngle) {
            return;
        }
        if (this.targetBodyAngle > this.bodyAngle) {
            this.bodyAngle += 2.0f * partialTicks;
            if (this.bodyAngle > this.targetBodyAngle) {
                this.bodyAngle = this.targetBodyAngle;
            }
        } else {
            this.bodyAngle -= 1.0f * partialTicks;
            if (this.bodyAngle < this.targetBodyAngle) {
                this.bodyAngle = this.targetBodyAngle;
            }
        }
    }

    public void calculateAngles(float partialTicks) {
        this.calculateBodyAngle(partialTicks);
        this.calculateWingAngle(partialTicks);
    }

    public float getBodyAngle() {
        return (float)Math.toRadians(this.bodyAngle);
    }

    public float getWingAngle() {
        return this.wingAngle;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState blockIn, BlockPos pos) {
    }

    public int func_70627_aG() {
        return Config.owlHootInterval;
    }

    public void func_70642_aH() {
        SoundEvent snd = this.func_184639_G();
        if (snd == null) {
            return;
        }
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K && (this.field_70170_p.func_72935_r() || this.func_70638_az() != null)) {
            return;
        }
        float volume = this.func_70599_aP() * Config.owlHootVolumeMult;
        float pitch = 0.8f * this.func_70647_i();
        this.func_184185_a(snd, volume, pitch);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            return SND_HOOT2;
        }
        return SND_HOOT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SND_HURT;
    }

    public EntityOwl createChild(EntityAgeable ageable) {
        return new EntityOwl(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151070_bp;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151008_G;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public float getMaxTurnRate() {
        return this.turnRate;
    }

    @Override
    public float getMaxClimbRate() {
        return this.climbRate;
    }

    @Override
    public EntityCreature asEntityCreature() {
        return this;
    }

    private int getNextLayingTime() {
        int dif = Config.owlTimeBetweenEggsMax - Config.owlTimeBetweenEggsMin;
        return Config.owlTimeBetweenEggsMin + this.field_70146_Z.nextInt(dif);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = tagCompund.func_74762_e("EggLayTime");
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public boolean func_184652_a(EntityPlayer player) {
        boolean ret = !this.func_110167_bD() && this instanceof IMob;
        return ret;
    }

    static {
        SND_HOOT.setRegistryName("enderzoo:owl.hootSingle");
        SND_HOOT2 = new SoundEvent(new ResourceLocation("enderzoo", "owl.hootDouble"));
        SND_HOOT2.setRegistryName("owl.hootDouble");
        SND_HURT = new SoundEvent(new ResourceLocation("enderzoo", "owl.hurt"));
        SND_HURT.setRegistryName("owl.hurt");
    }
}

