/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.ai.EntityAIAttackOnCollideAggressive;
import crazypants.enderzoo.entity.ai.EntityAINearestAttackableTargetBounded;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDireWolf
extends EntityMob
implements IEnderZooMob {
    public static final String NAME = "direwolf";
    public static final int EGG_BG_COL = 0x606060;
    public static final int EGG_FG_COL = 0xA0A0A0;
    private static final SoundEvent SND_HURT = new SoundEvent(new ResourceLocation("enderzoo:direwolf.hurt"));
    private static final SoundEvent SND_HOWL = new SoundEvent(new ResourceLocation("enderzoo:direwolf.howl"));
    private static final SoundEvent SND_GROWL = new SoundEvent(new ResourceLocation("enderzoo:direwolf.growl"));
    private static final SoundEvent SND_DEATH = new SoundEvent(new ResourceLocation("enderzoo:direwolf.death"));
    private static final DataParameter<Boolean> ANGRY_INDEX = EntityDataManager.func_187226_a(EntityDireWolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityLivingBase previsousAttackTarget;
    private static int packHowl = 0;
    private static long lastHowl = 0L;

    public EntityDireWolf(World world) {
        super(world);
        this.func_70105_a(0.8f, 1.2f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollideAggressive((EntityCreature)this, 1.1, true).setAttackFrequency(20));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        if (Config.direWolfAggresiveRange > 0.0) {
            EntityAINearestAttackableTargetBounded<EntityPlayer> nearTarg = new EntityAINearestAttackableTargetBounded<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true);
            nearTarg.setMaxDistanceToTarget(Config.direWolfAggresiveRange);
            this.field_70715_bh.func_75776_a(2, nearTarg);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY_INDEX, (Object)Boolean.FALSE);
        this.updateAngry();
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY_INDEX);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 6;
    }

    private void updateAngry() {
        this.field_70180_af.func_187227_b(ANGRY_INDEX, (Object)(this.func_70638_az() != null ? Boolean.TRUE : Boolean.FALSE));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        MobInfo.DIRE_WOLF.applyAttributes((EntityLivingBase)this);
    }

    protected void func_180429_a(BlockPos bp, Block p_145780_4_) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        boolean howl;
        if (this.isAngry()) {
            return SND_GROWL;
        }
        if (EntityUtil.isPlayerWithinRange((Entity)this, 12.0)) {
            return SND_GROWL;
        }
        boolean bl = howl = (packHowl > 0 || (double)this.field_70146_Z.nextFloat() <= Config.direWolfHowlChance) && this.field_70170_p.func_82737_E() > lastHowl + 10L;
        if (howl) {
            if (packHowl <= 0 && (double)this.field_70146_Z.nextFloat() <= 0.6) {
                packHowl = Config.direWolfPackHowlAmount;
            }
            lastHowl = this.field_70170_p.func_82737_E();
            packHowl = Math.max(packHowl - 1, 0);
            return SND_HOWL;
        }
        return SND_GROWL;
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        if (SND_HOWL.equals(sound)) {
            volume *= (float)Config.direWolfHowlVolumeMult;
            pitch *= 0.8f;
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch, true);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SND_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)-1);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5707964f;
        }
        return 0.7853982f;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double hw = this.field_70130_N / 2.0f;
        double hd = hw * 2.25;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - hw, y, z - hd, x + hw, y + (double)f1, z + hd));
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase curTarget = this.func_70638_az();
        if (curTarget != this.previsousAttackTarget) {
            if (curTarget != null) {
                this.doGroupArgo(curTarget);
            }
            this.previsousAttackTarget = this.func_70638_az();
            this.updateAngry();
        }
    }

    private void doGroupArgo(EntityLivingBase curTarget) {
        if (!Config.direWolfPackAttackEnabled) {
            return;
        }
        int range = 16;
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range);
        List pack = this.field_70170_p.func_72872_a(EntityDireWolf.class, bb);
        if (pack != null && !pack.isEmpty()) {
            for (EntityDireWolf wolf : pack) {
                if (wolf.func_70638_az() != null) continue;
                EntityUtil.cancelCurrentTasks((EntityLiving)wolf);
                wolf.func_70624_b(curTarget);
            }
        }
    }
}

