/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.proxy;

import com.m4thg33k.tombmanygraves.TombManyGraves;
import com.m4thg33k.tombmanygraves.client.fx.PathFX;
import com.m4thg33k.tombmanygraves.client.render.ItemRenderRegister;
import com.m4thg33k.tombmanygraves.client.render.ModRenders;
import com.m4thg33k.tombmanygraves.events.ClientEvents;
import com.m4thg33k.tombmanygraves.events.RenderEvents;
import com.m4thg33k.tombmanygraves.lib.ModConfigs;
import com.m4thg33k.tombmanygraves.proxy.CommonProxy;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.lwjgl.util.vector.Vector3f;

public class ClientProxy
extends CommonProxy {
    private Color NEAR;
    private Color FAR;

    @Override
    public void preinit(FMLPreInitializationEvent e) {
        super.preinit(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        ModRenders.init();
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        ItemRenderRegister.initClient(mesher);
        this.NEAR = ModConfigs.NEAR_PARTICLE;
        this.FAR = ModConfigs.FAR_PARTICLE;
    }

    @Override
    public void postinit(FMLPostInitializationEvent e) {
        super.postinit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
    }

    @Override
    public void particleStream(Vector3f start, Vector3f end) {
        Vector3f diff = Vector3f.sub((Vector3f)start, (Vector3f)end, null);
        float length = diff.length();
        float scale = diff.length() < 5.0f ? 10.0f : diff.length();
        Vector3f motion = new Vector3f(diff.x / scale, diff.y / scale, diff.z / scale);
        float[] color = this.getParticleColor(length);
        TombManyGraves.proxy.pathFX(start.x, start.y, start.z, color[0] / 255.0f, color[1] / 255.0f, color[2] / 255.0f, 0.4f, motion.x, motion.y, motion.z, 1.0f);
    }

    private float[] getParticleColor(float length) {
        float[] ret = new float[3];
        if (length < 10.0f) {
            ret[0] = this.NEAR.getRed();
            ret[1] = this.NEAR.getGreen();
            ret[2] = this.NEAR.getBlue();
        } else if (length > 100.0f) {
            ret[0] = this.FAR.getRed();
            ret[1] = this.FAR.getGreen();
            ret[2] = this.FAR.getBlue();
        } else {
            ret[0] = this.intermediateValue(length, this.FAR.getRed(), this.NEAR.getRed());
            ret[1] = this.intermediateValue(length, this.FAR.getGreen(), this.NEAR.getGreen());
            ret[2] = this.intermediateValue(length, this.FAR.getBlue(), this.NEAR.getBlue());
        }
        return ret;
    }

    private int intermediateValue(float length, int far, int near) {
        return (int)((double)((float)(far - near) * length) / 90.0 + (double)(10 * near - far) / 9.0);
    }

    @Override
    public void pathFX(double x, double y, double z, float r, float g, float b, float size, float motionX, float motionY, float motionZ, float maxAge) {
        if (!ModConfigs.ALLOW_PARTICLE_PATH) {
            return;
        }
        PathFX path = new PathFX((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, r, g, b, true, false, maxAge);
        path.setSpeed(motionX, motionY, motionZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)path);
    }

    @Override
    public void toggleGraveRendering() {
        ModConfigs.GRAVE_RENDERING_ENABLED = !ModConfigs.GRAVE_RENDERING_ENABLED;
    }

    @Override
    public void toggleGravePositionRendering() {
        ModConfigs.GRAVE_POS_ENABLED = !ModConfigs.GRAVE_POS_ENABLED;
    }
}

