/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.network.packets;

import com.m4thg33k.tombmanygraves.client.gui.InventoryFileManagerGui;
import com.m4thg33k.tombmanygraves.network.packets.BaseThreadsafePacket;
import com.m4thg33k.tombmanygraves.util.LogHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketFileNames
extends BaseThreadsafePacket {
    private List<String> files = new ArrayList<String>();
    private BlockPos pos;

    public PacketFileNames() {
    }

    public PacketFileNames(BlockPos pos, List<String> fileNames) {
        LogHelper.info("Created PacketFileName with " + fileNames.size() + " file names!");
        this.pos = pos;
        this.files.addAll(fileNames);
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof InventoryFileManagerGui) {
            LogHelper.info("Received information on the client!");
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Client-side only!");
    }

    public void fromBytes(ByteBuf buf) {
        LogHelper.info("reading PFN from buffer");
        this.pos = this.readPos(buf);
        this.files = new ArrayList<String>();
        for (int size = buf.readInt(); size > 0; --size) {
            this.files.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        LogHelper.info("writing PFN to buffer");
        this.writePos(this.pos, buf);
        buf.writeInt(this.files.size());
        for (String file : this.files) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)file);
        }
    }
}

